/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.GetCommercePlanListRequest;
import com.clerk.backend_api.models.operations.GetCommercePlanListResponse;
import com.clerk.backend_api.models.operations.PayerType;
import com.clerk.backend_api.operations.GetCommercePlanList;
import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Optional;

public class GetCommercePlanListRequestBuilder {
    private Optional<Boolean> paginated = Optional.empty();
    private Optional<Long> limit = Utils.readDefaultOrConstValue("limit", "10", new TypeReference<Optional<Long>>(){});
    private Optional<Long> offset = Utils.readDefaultOrConstValue("offset", "0", new TypeReference<Optional<Long>>(){});
    private Optional<? extends PayerType> payerType = Optional.empty();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Limit = new LazySingletonValue<Optional<Long>>("limit", "10", new TypeReference<Optional<Long>>(){});
    private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Offset = new LazySingletonValue<Optional<Long>>("offset", "0", new TypeReference<Optional<Long>>(){});

    public GetCommercePlanListRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public GetCommercePlanListRequestBuilder paginated(boolean paginated) {
        Utils.checkNotNull(paginated, "paginated");
        this.paginated = Optional.of(paginated);
        return this;
    }

    public GetCommercePlanListRequestBuilder paginated(Optional<Boolean> paginated) {
        Utils.checkNotNull(paginated, "paginated");
        this.paginated = paginated;
        return this;
    }

    public GetCommercePlanListRequestBuilder limit(long limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.of(limit);
        return this;
    }

    public GetCommercePlanListRequestBuilder limit(Optional<Long> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public GetCommercePlanListRequestBuilder offset(long offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = Optional.of(offset);
        return this;
    }

    public GetCommercePlanListRequestBuilder offset(Optional<Long> offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = offset;
        return this;
    }

    public GetCommercePlanListRequestBuilder payerType(PayerType payerType) {
        Utils.checkNotNull(payerType, "payerType");
        this.payerType = Optional.of(payerType);
        return this;
    }

    public GetCommercePlanListRequestBuilder payerType(Optional<? extends PayerType> payerType) {
        Utils.checkNotNull(payerType, "payerType");
        this.payerType = payerType;
        return this;
    }

    public GetCommercePlanListRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public GetCommercePlanListRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private GetCommercePlanListRequest buildRequest() {
        if (this.limit == null) {
            this.limit = _SINGLETON_VALUE_Limit.value();
        }
        if (this.offset == null) {
            this.offset = _SINGLETON_VALUE_Offset.value();
        }
        GetCommercePlanListRequest request = new GetCommercePlanListRequest(this.paginated, this.limit, this.offset, this.payerType);
        return request;
    }

    public GetCommercePlanListResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        GetCommercePlanList.Sync operation = new GetCommercePlanList.Sync(this.sdkConfiguration, options);
        GetCommercePlanListRequest request = this.buildRequest();
        return (GetCommercePlanListResponse)operation.handleResponse(operation.doRequest(request));
    }
}

