/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.PaginatedCommercePlanResponse;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class GetCommercePlanListResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends PaginatedCommercePlanResponse> paginatedCommercePlanResponse;

    @JsonCreator
    public GetCommercePlanListResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends PaginatedCommercePlanResponse> paginatedCommercePlanResponse) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(paginatedCommercePlanResponse, "paginatedCommercePlanResponse");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.paginatedCommercePlanResponse = paginatedCommercePlanResponse;
    }

    public GetCommercePlanListResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<PaginatedCommercePlanResponse> paginatedCommercePlanResponse() {
        return this.paginatedCommercePlanResponse;
    }

    public static Builder builder() {
        return new Builder();
    }

    public GetCommercePlanListResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public GetCommercePlanListResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public GetCommercePlanListResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public GetCommercePlanListResponse withPaginatedCommercePlanResponse(PaginatedCommercePlanResponse paginatedCommercePlanResponse) {
        Utils.checkNotNull(paginatedCommercePlanResponse, "paginatedCommercePlanResponse");
        this.paginatedCommercePlanResponse = Optional.ofNullable(paginatedCommercePlanResponse);
        return this;
    }

    public GetCommercePlanListResponse withPaginatedCommercePlanResponse(Optional<? extends PaginatedCommercePlanResponse> paginatedCommercePlanResponse) {
        Utils.checkNotNull(paginatedCommercePlanResponse, "paginatedCommercePlanResponse");
        this.paginatedCommercePlanResponse = paginatedCommercePlanResponse;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetCommercePlanListResponse other = (GetCommercePlanListResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.paginatedCommercePlanResponse, other.paginatedCommercePlanResponse);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.paginatedCommercePlanResponse);
    }

    public String toString() {
        return Utils.toString(GetCommercePlanListResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "paginatedCommercePlanResponse", this.paginatedCommercePlanResponse);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends PaginatedCommercePlanResponse> paginatedCommercePlanResponse = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder paginatedCommercePlanResponse(PaginatedCommercePlanResponse paginatedCommercePlanResponse) {
            Utils.checkNotNull(paginatedCommercePlanResponse, "paginatedCommercePlanResponse");
            this.paginatedCommercePlanResponse = Optional.ofNullable(paginatedCommercePlanResponse);
            return this;
        }

        public Builder paginatedCommercePlanResponse(Optional<? extends PaginatedCommercePlanResponse> paginatedCommercePlanResponse) {
            Utils.checkNotNull(paginatedCommercePlanResponse, "paginatedCommercePlanResponse");
            this.paginatedCommercePlanResponse = paginatedCommercePlanResponse;
            return this;
        }

        public GetCommercePlanListResponse build() {
            return new GetCommercePlanListResponse(this.contentType, this.statusCode, this.rawResponse, this.paginatedCommercePlanResponse);
        }
    }
}

