/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.GetCommerceSubscriptionItemListQueryParamStatus;
import com.clerk.backend_api.models.operations.QueryParamPayerType;
import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Optional;

public class GetCommerceSubscriptionItemListRequest {
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=paginated")
    private Optional<Boolean> paginated;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=limit")
    private Optional<Long> limit;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=offset")
    private Optional<Long> offset;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=status")
    private Optional<? extends GetCommerceSubscriptionItemListQueryParamStatus> status;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=payer_type")
    private Optional<? extends QueryParamPayerType> payerType;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=plan_id")
    private Optional<String> planId;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=include_free")
    private Optional<Boolean> includeFree;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=query")
    private Optional<String> query;

    @JsonCreator
    public GetCommerceSubscriptionItemListRequest(Optional<Boolean> paginated, Optional<Long> limit, Optional<Long> offset, Optional<? extends GetCommerceSubscriptionItemListQueryParamStatus> status, Optional<? extends QueryParamPayerType> payerType, Optional<String> planId, Optional<Boolean> includeFree, Optional<String> query) {
        Utils.checkNotNull(paginated, "paginated");
        Utils.checkNotNull(limit, "limit");
        Utils.checkNotNull(offset, "offset");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(payerType, "payerType");
        Utils.checkNotNull(planId, "planId");
        Utils.checkNotNull(includeFree, "includeFree");
        Utils.checkNotNull(query, "query");
        this.paginated = paginated;
        this.limit = limit;
        this.offset = offset;
        this.status = status;
        this.payerType = payerType;
        this.planId = planId;
        this.includeFree = includeFree;
        this.query = query;
    }

    public GetCommerceSubscriptionItemListRequest() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<Boolean> paginated() {
        return this.paginated;
    }

    @JsonIgnore
    public Optional<Long> limit() {
        return this.limit;
    }

    @JsonIgnore
    public Optional<Long> offset() {
        return this.offset;
    }

    @JsonIgnore
    public Optional<GetCommerceSubscriptionItemListQueryParamStatus> status() {
        return this.status;
    }

    @JsonIgnore
    public Optional<QueryParamPayerType> payerType() {
        return this.payerType;
    }

    @JsonIgnore
    public Optional<String> planId() {
        return this.planId;
    }

    @JsonIgnore
    public Optional<Boolean> includeFree() {
        return this.includeFree;
    }

    @JsonIgnore
    public Optional<String> query() {
        return this.query;
    }

    public static Builder builder() {
        return new Builder();
    }

    public GetCommerceSubscriptionItemListRequest withPaginated(boolean paginated) {
        Utils.checkNotNull(paginated, "paginated");
        this.paginated = Optional.ofNullable(paginated);
        return this;
    }

    public GetCommerceSubscriptionItemListRequest withPaginated(Optional<Boolean> paginated) {
        Utils.checkNotNull(paginated, "paginated");
        this.paginated = paginated;
        return this;
    }

    public GetCommerceSubscriptionItemListRequest withLimit(long limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.ofNullable(limit);
        return this;
    }

    public GetCommerceSubscriptionItemListRequest withLimit(Optional<Long> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public GetCommerceSubscriptionItemListRequest withOffset(long offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = Optional.ofNullable(offset);
        return this;
    }

    public GetCommerceSubscriptionItemListRequest withOffset(Optional<Long> offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = offset;
        return this;
    }

    public GetCommerceSubscriptionItemListRequest withStatus(GetCommerceSubscriptionItemListQueryParamStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = Optional.ofNullable(status);
        return this;
    }

    public GetCommerceSubscriptionItemListRequest withStatus(Optional<? extends GetCommerceSubscriptionItemListQueryParamStatus> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public GetCommerceSubscriptionItemListRequest withPayerType(QueryParamPayerType payerType) {
        Utils.checkNotNull(payerType, "payerType");
        this.payerType = Optional.ofNullable(payerType);
        return this;
    }

    public GetCommerceSubscriptionItemListRequest withPayerType(Optional<? extends QueryParamPayerType> payerType) {
        Utils.checkNotNull(payerType, "payerType");
        this.payerType = payerType;
        return this;
    }

    public GetCommerceSubscriptionItemListRequest withPlanId(String planId) {
        Utils.checkNotNull(planId, "planId");
        this.planId = Optional.ofNullable(planId);
        return this;
    }

    public GetCommerceSubscriptionItemListRequest withPlanId(Optional<String> planId) {
        Utils.checkNotNull(planId, "planId");
        this.planId = planId;
        return this;
    }

    public GetCommerceSubscriptionItemListRequest withIncludeFree(boolean includeFree) {
        Utils.checkNotNull(includeFree, "includeFree");
        this.includeFree = Optional.ofNullable(includeFree);
        return this;
    }

    public GetCommerceSubscriptionItemListRequest withIncludeFree(Optional<Boolean> includeFree) {
        Utils.checkNotNull(includeFree, "includeFree");
        this.includeFree = includeFree;
        return this;
    }

    public GetCommerceSubscriptionItemListRequest withQuery(String query) {
        Utils.checkNotNull(query, "query");
        this.query = Optional.ofNullable(query);
        return this;
    }

    public GetCommerceSubscriptionItemListRequest withQuery(Optional<String> query) {
        Utils.checkNotNull(query, "query");
        this.query = query;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetCommerceSubscriptionItemListRequest other = (GetCommerceSubscriptionItemListRequest)o;
        return Utils.enhancedDeepEquals(this.paginated, other.paginated) && Utils.enhancedDeepEquals(this.limit, other.limit) && Utils.enhancedDeepEquals(this.offset, other.offset) && Utils.enhancedDeepEquals(this.status, other.status) && Utils.enhancedDeepEquals(this.payerType, other.payerType) && Utils.enhancedDeepEquals(this.planId, other.planId) && Utils.enhancedDeepEquals(this.includeFree, other.includeFree) && Utils.enhancedDeepEquals(this.query, other.query);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.paginated, this.limit, this.offset, this.status, this.payerType, this.planId, this.includeFree, this.query);
    }

    public String toString() {
        return Utils.toString(GetCommerceSubscriptionItemListRequest.class, "paginated", this.paginated, "limit", this.limit, "offset", this.offset, "status", this.status, "payerType", this.payerType, "planId", this.planId, "includeFree", this.includeFree, "query", this.query);
    }

    public static final class Builder {
        private Optional<Boolean> paginated = Optional.empty();
        private Optional<Long> limit;
        private Optional<Long> offset;
        private Optional<? extends GetCommerceSubscriptionItemListQueryParamStatus> status = Optional.empty();
        private Optional<? extends QueryParamPayerType> payerType = Optional.empty();
        private Optional<String> planId = Optional.empty();
        private Optional<Boolean> includeFree;
        private Optional<String> query = Optional.empty();
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Limit = new LazySingletonValue<Optional<Long>>("limit", "10", new TypeReference<Optional<Long>>(){});
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Offset = new LazySingletonValue<Optional<Long>>("offset", "0", new TypeReference<Optional<Long>>(){});
        private static final LazySingletonValue<Optional<Boolean>> _SINGLETON_VALUE_IncludeFree = new LazySingletonValue<Optional<Boolean>>("include_free", "false", new TypeReference<Optional<Boolean>>(){});

        private Builder() {
        }

        public Builder paginated(boolean paginated) {
            Utils.checkNotNull(paginated, "paginated");
            this.paginated = Optional.ofNullable(paginated);
            return this;
        }

        public Builder paginated(Optional<Boolean> paginated) {
            Utils.checkNotNull(paginated, "paginated");
            this.paginated = paginated;
            return this;
        }

        public Builder limit(long limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public Builder limit(Optional<Long> limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = limit;
            return this;
        }

        public Builder offset(long offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public Builder offset(Optional<Long> offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = offset;
            return this;
        }

        public Builder status(GetCommerceSubscriptionItemListQueryParamStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = Optional.ofNullable(status);
            return this;
        }

        public Builder status(Optional<? extends GetCommerceSubscriptionItemListQueryParamStatus> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder payerType(QueryParamPayerType payerType) {
            Utils.checkNotNull(payerType, "payerType");
            this.payerType = Optional.ofNullable(payerType);
            return this;
        }

        public Builder payerType(Optional<? extends QueryParamPayerType> payerType) {
            Utils.checkNotNull(payerType, "payerType");
            this.payerType = payerType;
            return this;
        }

        public Builder planId(String planId) {
            Utils.checkNotNull(planId, "planId");
            this.planId = Optional.ofNullable(planId);
            return this;
        }

        public Builder planId(Optional<String> planId) {
            Utils.checkNotNull(planId, "planId");
            this.planId = planId;
            return this;
        }

        public Builder includeFree(boolean includeFree) {
            Utils.checkNotNull(includeFree, "includeFree");
            this.includeFree = Optional.ofNullable(includeFree);
            return this;
        }

        public Builder includeFree(Optional<Boolean> includeFree) {
            Utils.checkNotNull(includeFree, "includeFree");
            this.includeFree = includeFree;
            return this;
        }

        public Builder query(String query) {
            Utils.checkNotNull(query, "query");
            this.query = Optional.ofNullable(query);
            return this;
        }

        public Builder query(Optional<String> query) {
            Utils.checkNotNull(query, "query");
            this.query = query;
            return this;
        }

        public GetCommerceSubscriptionItemListRequest build() {
            if (this.limit == null) {
                this.limit = _SINGLETON_VALUE_Limit.value();
            }
            if (this.offset == null) {
                this.offset = _SINGLETON_VALUE_Offset.value();
            }
            if (this.includeFree == null) {
                this.includeFree = _SINGLETON_VALUE_IncludeFree.value();
            }
            return new GetCommerceSubscriptionItemListRequest(this.paginated, this.limit, this.offset, this.status, this.payerType, this.planId, this.includeFree, this.query);
        }
    }
}

