/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.PaginatedCommerceSubscriptionItemResponse;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class GetCommerceSubscriptionItemListResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends PaginatedCommerceSubscriptionItemResponse> paginatedCommerceSubscriptionItemResponse;

    @JsonCreator
    public GetCommerceSubscriptionItemListResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends PaginatedCommerceSubscriptionItemResponse> paginatedCommerceSubscriptionItemResponse) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(paginatedCommerceSubscriptionItemResponse, "paginatedCommerceSubscriptionItemResponse");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.paginatedCommerceSubscriptionItemResponse = paginatedCommerceSubscriptionItemResponse;
    }

    public GetCommerceSubscriptionItemListResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<PaginatedCommerceSubscriptionItemResponse> paginatedCommerceSubscriptionItemResponse() {
        return this.paginatedCommerceSubscriptionItemResponse;
    }

    public static Builder builder() {
        return new Builder();
    }

    public GetCommerceSubscriptionItemListResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public GetCommerceSubscriptionItemListResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public GetCommerceSubscriptionItemListResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public GetCommerceSubscriptionItemListResponse withPaginatedCommerceSubscriptionItemResponse(PaginatedCommerceSubscriptionItemResponse paginatedCommerceSubscriptionItemResponse) {
        Utils.checkNotNull(paginatedCommerceSubscriptionItemResponse, "paginatedCommerceSubscriptionItemResponse");
        this.paginatedCommerceSubscriptionItemResponse = Optional.ofNullable(paginatedCommerceSubscriptionItemResponse);
        return this;
    }

    public GetCommerceSubscriptionItemListResponse withPaginatedCommerceSubscriptionItemResponse(Optional<? extends PaginatedCommerceSubscriptionItemResponse> paginatedCommerceSubscriptionItemResponse) {
        Utils.checkNotNull(paginatedCommerceSubscriptionItemResponse, "paginatedCommerceSubscriptionItemResponse");
        this.paginatedCommerceSubscriptionItemResponse = paginatedCommerceSubscriptionItemResponse;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetCommerceSubscriptionItemListResponse other = (GetCommerceSubscriptionItemListResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.paginatedCommerceSubscriptionItemResponse, other.paginatedCommerceSubscriptionItemResponse);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.paginatedCommerceSubscriptionItemResponse);
    }

    public String toString() {
        return Utils.toString(GetCommerceSubscriptionItemListResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "paginatedCommerceSubscriptionItemResponse", this.paginatedCommerceSubscriptionItemResponse);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends PaginatedCommerceSubscriptionItemResponse> paginatedCommerceSubscriptionItemResponse = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder paginatedCommerceSubscriptionItemResponse(PaginatedCommerceSubscriptionItemResponse paginatedCommerceSubscriptionItemResponse) {
            Utils.checkNotNull(paginatedCommerceSubscriptionItemResponse, "paginatedCommerceSubscriptionItemResponse");
            this.paginatedCommerceSubscriptionItemResponse = Optional.ofNullable(paginatedCommerceSubscriptionItemResponse);
            return this;
        }

        public Builder paginatedCommerceSubscriptionItemResponse(Optional<? extends PaginatedCommerceSubscriptionItemResponse> paginatedCommerceSubscriptionItemResponse) {
            Utils.checkNotNull(paginatedCommerceSubscriptionItemResponse, "paginatedCommerceSubscriptionItemResponse");
            this.paginatedCommerceSubscriptionItemResponse = paginatedCommerceSubscriptionItemResponse;
            return this;
        }

        public GetCommerceSubscriptionItemListResponse build() {
            return new GetCommerceSubscriptionItemListResponse(this.contentType, this.statusCode, this.rawResponse, this.paginatedCommerceSubscriptionItemResponse);
        }
    }
}

