/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.GetEmailAddressRequest;
import com.clerk.backend_api.models.operations.GetEmailAddressResponse;
import com.clerk.backend_api.operations.GetEmailAddress;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class GetEmailAddressRequestBuilder {
    private String emailAddressId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public GetEmailAddressRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public GetEmailAddressRequestBuilder emailAddressId(String emailAddressId) {
        Utils.checkNotNull(emailAddressId, "emailAddressId");
        this.emailAddressId = emailAddressId;
        return this;
    }

    public GetEmailAddressRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public GetEmailAddressRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private GetEmailAddressRequest buildRequest() {
        GetEmailAddressRequest request = new GetEmailAddressRequest(this.emailAddressId);
        return request;
    }

    public GetEmailAddressResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        GetEmailAddress.Sync operation = new GetEmailAddress.Sync(this.sdkConfiguration, options);
        GetEmailAddressRequest request = this.buildRequest();
        return (GetEmailAddressResponse)operation.handleResponse(operation.doRequest(request));
    }
}

