/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.GetJWTTemplateRequest;
import com.clerk.backend_api.models.operations.GetJWTTemplateResponse;
import com.clerk.backend_api.operations.GetJWTTemplate;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class GetJWTTemplateRequestBuilder {
    private String templateId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public GetJWTTemplateRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public GetJWTTemplateRequestBuilder templateId(String templateId) {
        Utils.checkNotNull(templateId, "templateId");
        this.templateId = templateId;
        return this;
    }

    public GetJWTTemplateRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public GetJWTTemplateRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private GetJWTTemplateRequest buildRequest() {
        GetJWTTemplateRequest request = new GetJWTTemplateRequest(this.templateId);
        return request;
    }

    public GetJWTTemplateResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        GetJWTTemplate.Sync operation = new GetJWTTemplate.Sync(this.sdkConfiguration, options);
        GetJWTTemplateRequest request = this.buildRequest();
        return (GetJWTTemplateResponse)operation.handleResponse(operation.doRequest(request));
    }
}

