/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class GetM2MTokensRequest {
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=subject")
    private String subject;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=revoked")
    private JsonNullable<Boolean> revoked;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=expired")
    private JsonNullable<Boolean> expired;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=limit")
    private Optional<Double> limit;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=offset")
    private JsonNullable<Double> offset;

    @JsonCreator
    public GetM2MTokensRequest(String subject, JsonNullable<Boolean> revoked, JsonNullable<Boolean> expired, Optional<Double> limit, JsonNullable<Double> offset) {
        Utils.checkNotNull(subject, "subject");
        Utils.checkNotNull(revoked, "revoked");
        Utils.checkNotNull(expired, "expired");
        Utils.checkNotNull(limit, "limit");
        Utils.checkNotNull(offset, "offset");
        this.subject = subject;
        this.revoked = revoked;
        this.expired = expired;
        this.limit = limit;
        this.offset = offset;
    }

    public GetM2MTokensRequest(String subject) {
        this(subject, (JsonNullable<Boolean>)JsonNullable.undefined(), (JsonNullable<Boolean>)JsonNullable.undefined(), Optional.empty(), (JsonNullable<Double>)JsonNullable.undefined());
    }

    @JsonIgnore
    public String subject() {
        return this.subject;
    }

    @JsonIgnore
    public JsonNullable<Boolean> revoked() {
        return this.revoked;
    }

    @JsonIgnore
    public JsonNullable<Boolean> expired() {
        return this.expired;
    }

    @JsonIgnore
    public Optional<Double> limit() {
        return this.limit;
    }

    @JsonIgnore
    public JsonNullable<Double> offset() {
        return this.offset;
    }

    public static Builder builder() {
        return new Builder();
    }

    public GetM2MTokensRequest withSubject(String subject) {
        Utils.checkNotNull(subject, "subject");
        this.subject = subject;
        return this;
    }

    public GetM2MTokensRequest withRevoked(boolean revoked) {
        Utils.checkNotNull(revoked, "revoked");
        this.revoked = JsonNullable.of((Object)revoked);
        return this;
    }

    public GetM2MTokensRequest withRevoked(JsonNullable<Boolean> revoked) {
        Utils.checkNotNull(revoked, "revoked");
        this.revoked = revoked;
        return this;
    }

    public GetM2MTokensRequest withExpired(boolean expired) {
        Utils.checkNotNull(expired, "expired");
        this.expired = JsonNullable.of((Object)expired);
        return this;
    }

    public GetM2MTokensRequest withExpired(JsonNullable<Boolean> expired) {
        Utils.checkNotNull(expired, "expired");
        this.expired = expired;
        return this;
    }

    public GetM2MTokensRequest withLimit(double limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.ofNullable(limit);
        return this;
    }

    public GetM2MTokensRequest withLimit(Optional<Double> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public GetM2MTokensRequest withOffset(double offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = JsonNullable.of((Object)offset);
        return this;
    }

    public GetM2MTokensRequest withOffset(JsonNullable<Double> offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = offset;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetM2MTokensRequest other = (GetM2MTokensRequest)o;
        return Utils.enhancedDeepEquals(this.subject, other.subject) && Utils.enhancedDeepEquals(this.revoked, other.revoked) && Utils.enhancedDeepEquals(this.expired, other.expired) && Utils.enhancedDeepEquals(this.limit, other.limit) && Utils.enhancedDeepEquals(this.offset, other.offset);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.subject, this.revoked, this.expired, this.limit, this.offset);
    }

    public String toString() {
        return Utils.toString(GetM2MTokensRequest.class, "subject", this.subject, "revoked", this.revoked, "expired", this.expired, "limit", this.limit, "offset", this.offset);
    }

    public static final class Builder {
        private String subject;
        private JsonNullable<Boolean> revoked;
        private JsonNullable<Boolean> expired;
        private Optional<Double> limit;
        private JsonNullable<Double> offset;
        private static final LazySingletonValue<JsonNullable<Boolean>> _SINGLETON_VALUE_Revoked = new LazySingletonValue<JsonNullable<Boolean>>("revoked", "false", new TypeReference<JsonNullable<Boolean>>(){});
        private static final LazySingletonValue<JsonNullable<Boolean>> _SINGLETON_VALUE_Expired = new LazySingletonValue<JsonNullable<Boolean>>("expired", "false", new TypeReference<JsonNullable<Boolean>>(){});
        private static final LazySingletonValue<Optional<Double>> _SINGLETON_VALUE_Limit = new LazySingletonValue<Optional<Double>>("limit", "10", new TypeReference<Optional<Double>>(){});
        private static final LazySingletonValue<JsonNullable<Double>> _SINGLETON_VALUE_Offset = new LazySingletonValue<JsonNullable<Double>>("offset", "0", new TypeReference<JsonNullable<Double>>(){});

        private Builder() {
        }

        public Builder subject(String subject) {
            Utils.checkNotNull(subject, "subject");
            this.subject = subject;
            return this;
        }

        public Builder revoked(boolean revoked) {
            Utils.checkNotNull(revoked, "revoked");
            this.revoked = JsonNullable.of((Object)revoked);
            return this;
        }

        public Builder revoked(JsonNullable<Boolean> revoked) {
            Utils.checkNotNull(revoked, "revoked");
            this.revoked = revoked;
            return this;
        }

        public Builder expired(boolean expired) {
            Utils.checkNotNull(expired, "expired");
            this.expired = JsonNullable.of((Object)expired);
            return this;
        }

        public Builder expired(JsonNullable<Boolean> expired) {
            Utils.checkNotNull(expired, "expired");
            this.expired = expired;
            return this;
        }

        public Builder limit(double limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public Builder limit(Optional<Double> limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = limit;
            return this;
        }

        public Builder offset(double offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = JsonNullable.of((Object)offset);
            return this;
        }

        public Builder offset(JsonNullable<Double> offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = offset;
            return this;
        }

        public GetM2MTokensRequest build() {
            if (this.revoked == null) {
                this.revoked = _SINGLETON_VALUE_Revoked.value();
            }
            if (this.expired == null) {
                this.expired = _SINGLETON_VALUE_Expired.value();
            }
            if (this.limit == null) {
                this.limit = _SINGLETON_VALUE_Limit.value();
            }
            if (this.offset == null) {
                this.offset = _SINGLETON_VALUE_Offset.value();
            }
            return new GetM2MTokensRequest(this.subject, this.revoked, this.expired, this.limit, this.offset);
        }
    }
}

