/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class GetMachineRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=machine_id")
    private String machineId;

    @JsonCreator
    public GetMachineRequest(String machineId) {
        Utils.checkNotNull(machineId, "machineId");
        this.machineId = machineId;
    }

    @JsonIgnore
    public String machineId() {
        return this.machineId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public GetMachineRequest withMachineId(String machineId) {
        Utils.checkNotNull(machineId, "machineId");
        this.machineId = machineId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetMachineRequest other = (GetMachineRequest)o;
        return Utils.enhancedDeepEquals(this.machineId, other.machineId);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.machineId);
    }

    public String toString() {
        return Utils.toString(GetMachineRequest.class, "machineId", this.machineId);
    }

    public static final class Builder {
        private String machineId;

        private Builder() {
        }

        public Builder machineId(String machineId) {
            Utils.checkNotNull(machineId, "machineId");
            this.machineId = machineId;
            return this;
        }

        public GetMachineRequest build() {
            return new GetMachineRequest(this.machineId);
        }
    }
}

