/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.GetMachineRequest;
import com.clerk.backend_api.models.operations.GetMachineResponse;
import com.clerk.backend_api.operations.GetMachine;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class GetMachineRequestBuilder {
    private String machineId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public GetMachineRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public GetMachineRequestBuilder machineId(String machineId) {
        Utils.checkNotNull(machineId, "machineId");
        this.machineId = machineId;
        return this;
    }

    public GetMachineRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public GetMachineRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private GetMachineRequest buildRequest() {
        GetMachineRequest request = new GetMachineRequest(this.machineId);
        return request;
    }

    public GetMachineResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        GetMachine.Sync operation = new GetMachine.Sync(this.sdkConfiguration, options);
        GetMachineRequest request = this.buildRequest();
        return (GetMachineResponse)operation.handleResponse(operation.doRequest(request));
    }
}

