/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.GetMachineSecretKeyRequest;
import com.clerk.backend_api.models.operations.GetMachineSecretKeyResponse;
import com.clerk.backend_api.operations.GetMachineSecretKey;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class GetMachineSecretKeyRequestBuilder {
    private String machineId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public GetMachineSecretKeyRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public GetMachineSecretKeyRequestBuilder machineId(String machineId) {
        Utils.checkNotNull(machineId, "machineId");
        this.machineId = machineId;
        return this;
    }

    public GetMachineSecretKeyRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public GetMachineSecretKeyRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private GetMachineSecretKeyRequest buildRequest() {
        GetMachineSecretKeyRequest request = new GetMachineSecretKeyRequest(this.machineId);
        return request;
    }

    public GetMachineSecretKeyResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        GetMachineSecretKey.Sync operation = new GetMachineSecretKey.Sync(this.sdkConfiguration, options);
        GetMachineSecretKeyRequest request = this.buildRequest();
        return (GetMachineSecretKeyResponse)operation.handleResponse(operation.doRequest(request));
    }
}

