/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.MachineSecretKey;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class GetMachineSecretKeyResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends MachineSecretKey> machineSecretKey;

    @JsonCreator
    public GetMachineSecretKeyResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends MachineSecretKey> machineSecretKey) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(machineSecretKey, "machineSecretKey");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.machineSecretKey = machineSecretKey;
    }

    public GetMachineSecretKeyResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<MachineSecretKey> machineSecretKey() {
        return this.machineSecretKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public GetMachineSecretKeyResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public GetMachineSecretKeyResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public GetMachineSecretKeyResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public GetMachineSecretKeyResponse withMachineSecretKey(MachineSecretKey machineSecretKey) {
        Utils.checkNotNull(machineSecretKey, "machineSecretKey");
        this.machineSecretKey = Optional.ofNullable(machineSecretKey);
        return this;
    }

    public GetMachineSecretKeyResponse withMachineSecretKey(Optional<? extends MachineSecretKey> machineSecretKey) {
        Utils.checkNotNull(machineSecretKey, "machineSecretKey");
        this.machineSecretKey = machineSecretKey;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetMachineSecretKeyResponse other = (GetMachineSecretKeyResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.machineSecretKey, other.machineSecretKey);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.machineSecretKey);
    }

    public String toString() {
        return Utils.toString(GetMachineSecretKeyResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "machineSecretKey", this.machineSecretKey);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends MachineSecretKey> machineSecretKey = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder machineSecretKey(MachineSecretKey machineSecretKey) {
            Utils.checkNotNull(machineSecretKey, "machineSecretKey");
            this.machineSecretKey = Optional.ofNullable(machineSecretKey);
            return this;
        }

        public Builder machineSecretKey(Optional<? extends MachineSecretKey> machineSecretKey) {
            Utils.checkNotNull(machineSecretKey, "machineSecretKey");
            this.machineSecretKey = machineSecretKey;
            return this;
        }

        public GetMachineSecretKeyResponse build() {
            return new GetMachineSecretKeyResponse(this.contentType, this.statusCode, this.rawResponse, this.machineSecretKey);
        }
    }
}

