/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.GetOAuthApplicationRequest;
import com.clerk.backend_api.models.operations.GetOAuthApplicationResponse;
import com.clerk.backend_api.operations.GetOAuthApplication;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class GetOAuthApplicationRequestBuilder {
    private String oauthApplicationId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public GetOAuthApplicationRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public GetOAuthApplicationRequestBuilder oauthApplicationId(String oauthApplicationId) {
        Utils.checkNotNull(oauthApplicationId, "oauthApplicationId");
        this.oauthApplicationId = oauthApplicationId;
        return this;
    }

    public GetOAuthApplicationRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public GetOAuthApplicationRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private GetOAuthApplicationRequest buildRequest() {
        GetOAuthApplicationRequest request = new GetOAuthApplicationRequest(this.oauthApplicationId);
        return request;
    }

    public GetOAuthApplicationResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        GetOAuthApplication.Sync operation = new GetOAuthApplication.Sync(this.sdkConfiguration, options);
        GetOAuthApplicationRequest request = this.buildRequest();
        return (GetOAuthApplicationResponse)operation.handleResponse(operation.doRequest(request));
    }
}

