/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.OAuthApplication;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class GetOAuthApplicationResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends OAuthApplication> oAuthApplication;

    @JsonCreator
    public GetOAuthApplicationResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends OAuthApplication> oAuthApplication) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(oAuthApplication, "oAuthApplication");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.oAuthApplication = oAuthApplication;
    }

    public GetOAuthApplicationResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<OAuthApplication> oAuthApplication() {
        return this.oAuthApplication;
    }

    public static Builder builder() {
        return new Builder();
    }

    public GetOAuthApplicationResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public GetOAuthApplicationResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public GetOAuthApplicationResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public GetOAuthApplicationResponse withOAuthApplication(OAuthApplication oAuthApplication) {
        Utils.checkNotNull(oAuthApplication, "oAuthApplication");
        this.oAuthApplication = Optional.ofNullable(oAuthApplication);
        return this;
    }

    public GetOAuthApplicationResponse withOAuthApplication(Optional<? extends OAuthApplication> oAuthApplication) {
        Utils.checkNotNull(oAuthApplication, "oAuthApplication");
        this.oAuthApplication = oAuthApplication;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetOAuthApplicationResponse other = (GetOAuthApplicationResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.oAuthApplication, other.oAuthApplication);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.oAuthApplication);
    }

    public String toString() {
        return Utils.toString(GetOAuthApplicationResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "oAuthApplication", this.oAuthApplication);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends OAuthApplication> oAuthApplication = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder oAuthApplication(OAuthApplication oAuthApplication) {
            Utils.checkNotNull(oAuthApplication, "oAuthApplication");
            this.oAuthApplication = Optional.ofNullable(oAuthApplication);
            return this;
        }

        public Builder oAuthApplication(Optional<? extends OAuthApplication> oAuthApplication) {
            Utils.checkNotNull(oAuthApplication, "oAuthApplication");
            this.oAuthApplication = oAuthApplication;
            return this;
        }

        public GetOAuthApplicationResponse build() {
            return new GetOAuthApplicationResponse(this.contentType, this.statusCode, this.rawResponse, this.oAuthApplication);
        }
    }
}

