/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.GetOrganizationBillingSubscriptionRequest;
import com.clerk.backend_api.models.operations.GetOrganizationBillingSubscriptionResponse;
import com.clerk.backend_api.operations.GetOrganizationBillingSubscription;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class GetOrganizationBillingSubscriptionRequestBuilder {
    private String organizationId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public GetOrganizationBillingSubscriptionRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public GetOrganizationBillingSubscriptionRequestBuilder organizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public GetOrganizationBillingSubscriptionRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public GetOrganizationBillingSubscriptionRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private GetOrganizationBillingSubscriptionRequest buildRequest() {
        GetOrganizationBillingSubscriptionRequest request = new GetOrganizationBillingSubscriptionRequest(this.organizationId);
        return request;
    }

    public GetOrganizationBillingSubscriptionResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        GetOrganizationBillingSubscription.Sync operation = new GetOrganizationBillingSubscription.Sync(this.sdkConfiguration, options);
        GetOrganizationBillingSubscriptionRequest request = this.buildRequest();
        return (GetOrganizationBillingSubscriptionResponse)operation.handleResponse(operation.doRequest(request));
    }
}

