/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.GetOrganizationInvitationRequest;
import com.clerk.backend_api.models.operations.GetOrganizationInvitationResponse;
import com.clerk.backend_api.operations.GetOrganizationInvitation;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class GetOrganizationInvitationRequestBuilder {
    private String organizationId;
    private String invitationId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public GetOrganizationInvitationRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public GetOrganizationInvitationRequestBuilder organizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public GetOrganizationInvitationRequestBuilder invitationId(String invitationId) {
        Utils.checkNotNull(invitationId, "invitationId");
        this.invitationId = invitationId;
        return this;
    }

    public GetOrganizationInvitationRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public GetOrganizationInvitationRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private GetOrganizationInvitationRequest buildRequest() {
        GetOrganizationInvitationRequest request = new GetOrganizationInvitationRequest(this.organizationId, this.invitationId);
        return request;
    }

    public GetOrganizationInvitationResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        GetOrganizationInvitation.Sync operation = new GetOrganizationInvitation.Sync(this.sdkConfiguration, options);
        GetOrganizationInvitationRequest request = this.buildRequest();
        return (GetOrganizationInvitationResponse)operation.handleResponse(operation.doRequest(request));
    }
}

