/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.OrganizationInvitation;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class GetOrganizationInvitationResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends OrganizationInvitation> organizationInvitation;

    @JsonCreator
    public GetOrganizationInvitationResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends OrganizationInvitation> organizationInvitation) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(organizationInvitation, "organizationInvitation");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.organizationInvitation = organizationInvitation;
    }

    public GetOrganizationInvitationResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<OrganizationInvitation> organizationInvitation() {
        return this.organizationInvitation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public GetOrganizationInvitationResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public GetOrganizationInvitationResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public GetOrganizationInvitationResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public GetOrganizationInvitationResponse withOrganizationInvitation(OrganizationInvitation organizationInvitation) {
        Utils.checkNotNull(organizationInvitation, "organizationInvitation");
        this.organizationInvitation = Optional.ofNullable(organizationInvitation);
        return this;
    }

    public GetOrganizationInvitationResponse withOrganizationInvitation(Optional<? extends OrganizationInvitation> organizationInvitation) {
        Utils.checkNotNull(organizationInvitation, "organizationInvitation");
        this.organizationInvitation = organizationInvitation;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetOrganizationInvitationResponse other = (GetOrganizationInvitationResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.organizationInvitation, other.organizationInvitation);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.organizationInvitation);
    }

    public String toString() {
        return Utils.toString(GetOrganizationInvitationResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "organizationInvitation", this.organizationInvitation);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends OrganizationInvitation> organizationInvitation = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder organizationInvitation(OrganizationInvitation organizationInvitation) {
            Utils.checkNotNull(organizationInvitation, "organizationInvitation");
            this.organizationInvitation = Optional.ofNullable(organizationInvitation);
            return this;
        }

        public Builder organizationInvitation(Optional<? extends OrganizationInvitation> organizationInvitation) {
            Utils.checkNotNull(organizationInvitation, "organizationInvitation");
            this.organizationInvitation = organizationInvitation;
            return this;
        }

        public GetOrganizationInvitationResponse build() {
            return new GetOrganizationInvitationResponse(this.contentType, this.statusCode, this.rawResponse, this.organizationInvitation);
        }
    }
}

