/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.GetOrganizationRequest;
import com.clerk.backend_api.models.operations.GetOrganizationResponse;
import com.clerk.backend_api.operations.GetOrganization;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class GetOrganizationRequestBuilder {
    private String organizationId;
    private Optional<Boolean> includeMembersCount = Optional.empty();
    private Optional<Boolean> includeMissingMemberWithElevatedPermissions = Optional.empty();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public GetOrganizationRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public GetOrganizationRequestBuilder organizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public GetOrganizationRequestBuilder includeMembersCount(boolean includeMembersCount) {
        Utils.checkNotNull(includeMembersCount, "includeMembersCount");
        this.includeMembersCount = Optional.of(includeMembersCount);
        return this;
    }

    public GetOrganizationRequestBuilder includeMembersCount(Optional<Boolean> includeMembersCount) {
        Utils.checkNotNull(includeMembersCount, "includeMembersCount");
        this.includeMembersCount = includeMembersCount;
        return this;
    }

    public GetOrganizationRequestBuilder includeMissingMemberWithElevatedPermissions(boolean includeMissingMemberWithElevatedPermissions) {
        Utils.checkNotNull(includeMissingMemberWithElevatedPermissions, "includeMissingMemberWithElevatedPermissions");
        this.includeMissingMemberWithElevatedPermissions = Optional.of(includeMissingMemberWithElevatedPermissions);
        return this;
    }

    public GetOrganizationRequestBuilder includeMissingMemberWithElevatedPermissions(Optional<Boolean> includeMissingMemberWithElevatedPermissions) {
        Utils.checkNotNull(includeMissingMemberWithElevatedPermissions, "includeMissingMemberWithElevatedPermissions");
        this.includeMissingMemberWithElevatedPermissions = includeMissingMemberWithElevatedPermissions;
        return this;
    }

    public GetOrganizationRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public GetOrganizationRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private GetOrganizationRequest buildRequest() {
        GetOrganizationRequest request = new GetOrganizationRequest(this.organizationId, this.includeMembersCount, this.includeMissingMemberWithElevatedPermissions);
        return request;
    }

    public GetOrganizationResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        GetOrganization.Sync operation = new GetOrganization.Sync(this.sdkConfiguration, options);
        GetOrganizationRequest request = this.buildRequest();
        return (GetOrganizationResponse)operation.handleResponse(operation.doRequest(request));
    }
}

