/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.GetRedirectURLRequest;
import com.clerk.backend_api.models.operations.GetRedirectURLResponse;
import com.clerk.backend_api.operations.GetRedirectURL;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class GetRedirectURLRequestBuilder {
    private String id;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public GetRedirectURLRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public GetRedirectURLRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public GetRedirectURLRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public GetRedirectURLRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private GetRedirectURLRequest buildRequest() {
        GetRedirectURLRequest request = new GetRedirectURLRequest(this.id);
        return request;
    }

    public GetRedirectURLResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        GetRedirectURL.Sync operation = new GetRedirectURL.Sync(this.sdkConfiguration, options);
        GetRedirectURLRequest request = this.buildRequest();
        return (GetRedirectURLResponse)operation.handleResponse(operation.doRequest(request));
    }
}

