/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.GetSAMLConnectionRequest;
import com.clerk.backend_api.models.operations.GetSAMLConnectionResponse;
import com.clerk.backend_api.operations.GetSAMLConnection;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class GetSAMLConnectionRequestBuilder {
    private String samlConnectionId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public GetSAMLConnectionRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public GetSAMLConnectionRequestBuilder samlConnectionId(String samlConnectionId) {
        Utils.checkNotNull(samlConnectionId, "samlConnectionId");
        this.samlConnectionId = samlConnectionId;
        return this;
    }

    public GetSAMLConnectionRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public GetSAMLConnectionRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private GetSAMLConnectionRequest buildRequest() {
        GetSAMLConnectionRequest request = new GetSAMLConnectionRequest(this.samlConnectionId);
        return request;
    }

    public GetSAMLConnectionResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        GetSAMLConnection.Sync operation = new GetSAMLConnection.Sync(this.sdkConfiguration, options);
        GetSAMLConnectionRequest request = this.buildRequest();
        return (GetSAMLConnectionResponse)operation.handleResponse(operation.doRequest(request));
    }
}

