/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.Status;
import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Optional;

public class GetSessionListRequest {
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=client_id")
    private Optional<String> clientId;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=user_id")
    private Optional<String> userId;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=status")
    private Optional<? extends Status> status;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=paginated")
    private Optional<Boolean> paginated;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=limit")
    private Optional<Long> limit;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=offset")
    private Optional<Long> offset;

    @JsonCreator
    public GetSessionListRequest(Optional<String> clientId, Optional<String> userId, Optional<? extends Status> status, Optional<Boolean> paginated, Optional<Long> limit, Optional<Long> offset) {
        Utils.checkNotNull(clientId, "clientId");
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(paginated, "paginated");
        Utils.checkNotNull(limit, "limit");
        Utils.checkNotNull(offset, "offset");
        this.clientId = clientId;
        this.userId = userId;
        this.status = status;
        this.paginated = paginated;
        this.limit = limit;
        this.offset = offset;
    }

    public GetSessionListRequest() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> clientId() {
        return this.clientId;
    }

    @JsonIgnore
    public Optional<String> userId() {
        return this.userId;
    }

    @JsonIgnore
    public Optional<Status> status() {
        return this.status;
    }

    @JsonIgnore
    public Optional<Boolean> paginated() {
        return this.paginated;
    }

    @JsonIgnore
    public Optional<Long> limit() {
        return this.limit;
    }

    @JsonIgnore
    public Optional<Long> offset() {
        return this.offset;
    }

    public static Builder builder() {
        return new Builder();
    }

    public GetSessionListRequest withClientId(String clientId) {
        Utils.checkNotNull(clientId, "clientId");
        this.clientId = Optional.ofNullable(clientId);
        return this;
    }

    public GetSessionListRequest withClientId(Optional<String> clientId) {
        Utils.checkNotNull(clientId, "clientId");
        this.clientId = clientId;
        return this;
    }

    public GetSessionListRequest withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = Optional.ofNullable(userId);
        return this;
    }

    public GetSessionListRequest withUserId(Optional<String> userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public GetSessionListRequest withStatus(Status status) {
        Utils.checkNotNull(status, "status");
        this.status = Optional.ofNullable(status);
        return this;
    }

    public GetSessionListRequest withStatus(Optional<? extends Status> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public GetSessionListRequest withPaginated(boolean paginated) {
        Utils.checkNotNull(paginated, "paginated");
        this.paginated = Optional.ofNullable(paginated);
        return this;
    }

    public GetSessionListRequest withPaginated(Optional<Boolean> paginated) {
        Utils.checkNotNull(paginated, "paginated");
        this.paginated = paginated;
        return this;
    }

    public GetSessionListRequest withLimit(long limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.ofNullable(limit);
        return this;
    }

    public GetSessionListRequest withLimit(Optional<Long> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public GetSessionListRequest withOffset(long offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = Optional.ofNullable(offset);
        return this;
    }

    public GetSessionListRequest withOffset(Optional<Long> offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = offset;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetSessionListRequest other = (GetSessionListRequest)o;
        return Utils.enhancedDeepEquals(this.clientId, other.clientId) && Utils.enhancedDeepEquals(this.userId, other.userId) && Utils.enhancedDeepEquals(this.status, other.status) && Utils.enhancedDeepEquals(this.paginated, other.paginated) && Utils.enhancedDeepEquals(this.limit, other.limit) && Utils.enhancedDeepEquals(this.offset, other.offset);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.clientId, this.userId, this.status, this.paginated, this.limit, this.offset);
    }

    public String toString() {
        return Utils.toString(GetSessionListRequest.class, "clientId", this.clientId, "userId", this.userId, "status", this.status, "paginated", this.paginated, "limit", this.limit, "offset", this.offset);
    }

    public static final class Builder {
        private Optional<String> clientId = Optional.empty();
        private Optional<String> userId = Optional.empty();
        private Optional<? extends Status> status = Optional.empty();
        private Optional<Boolean> paginated = Optional.empty();
        private Optional<Long> limit;
        private Optional<Long> offset;
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Limit = new LazySingletonValue<Optional<Long>>("limit", "10", new TypeReference<Optional<Long>>(){});
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Offset = new LazySingletonValue<Optional<Long>>("offset", "0", new TypeReference<Optional<Long>>(){});

        private Builder() {
        }

        public Builder clientId(String clientId) {
            Utils.checkNotNull(clientId, "clientId");
            this.clientId = Optional.ofNullable(clientId);
            return this;
        }

        public Builder clientId(Optional<String> clientId) {
            Utils.checkNotNull(clientId, "clientId");
            this.clientId = clientId;
            return this;
        }

        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        public Builder userId(Optional<String> userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        public Builder status(Status status) {
            Utils.checkNotNull(status, "status");
            this.status = Optional.ofNullable(status);
            return this;
        }

        public Builder status(Optional<? extends Status> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder paginated(boolean paginated) {
            Utils.checkNotNull(paginated, "paginated");
            this.paginated = Optional.ofNullable(paginated);
            return this;
        }

        public Builder paginated(Optional<Boolean> paginated) {
            Utils.checkNotNull(paginated, "paginated");
            this.paginated = paginated;
            return this;
        }

        public Builder limit(long limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public Builder limit(Optional<Long> limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = limit;
            return this;
        }

        public Builder offset(long offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public Builder offset(Optional<Long> offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = offset;
            return this;
        }

        public GetSessionListRequest build() {
            if (this.limit == null) {
                this.limit = _SINGLETON_VALUE_Limit.value();
            }
            if (this.offset == null) {
                this.offset = _SINGLETON_VALUE_Offset.value();
            }
            return new GetSessionListRequest(this.clientId, this.userId, this.status, this.paginated, this.limit, this.offset);
        }
    }
}

