/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class GetSessionRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=session_id")
    private String sessionId;

    @JsonCreator
    public GetSessionRequest(String sessionId) {
        Utils.checkNotNull(sessionId, "sessionId");
        this.sessionId = sessionId;
    }

    @JsonIgnore
    public String sessionId() {
        return this.sessionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public GetSessionRequest withSessionId(String sessionId) {
        Utils.checkNotNull(sessionId, "sessionId");
        this.sessionId = sessionId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetSessionRequest other = (GetSessionRequest)o;
        return Utils.enhancedDeepEquals(this.sessionId, other.sessionId);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.sessionId);
    }

    public String toString() {
        return Utils.toString(GetSessionRequest.class, "sessionId", this.sessionId);
    }

    public static final class Builder {
        private String sessionId;

        private Builder() {
        }

        public Builder sessionId(String sessionId) {
            Utils.checkNotNull(sessionId, "sessionId");
            this.sessionId = sessionId;
            return this;
        }

        public GetSessionRequest build() {
            return new GetSessionRequest(this.sessionId);
        }
    }
}

