/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.GetSignUpRequest;
import com.clerk.backend_api.models.operations.GetSignUpResponse;
import com.clerk.backend_api.operations.GetSignUp;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class GetSignUpRequestBuilder {
    private String id;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public GetSignUpRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public GetSignUpRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public GetSignUpRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public GetSignUpRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private GetSignUpRequest buildRequest() {
        GetSignUpRequest request = new GetSignUpRequest(this.id);
        return request;
    }

    public GetSignUpResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        GetSignUp.Sync operation = new GetSignUp.Sync(this.sdkConfiguration, options);
        GetSignUpRequest request = this.buildRequest();
        return (GetSignUpResponse)operation.handleResponse(operation.doRequest(request));
    }
}

