/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.GetTemplateListRequest;
import com.clerk.backend_api.models.operations.GetTemplateListResponse;
import com.clerk.backend_api.models.operations.TemplateType;
import com.clerk.backend_api.operations.GetTemplateList;
import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Optional;

public class GetTemplateListRequestBuilder {
    private TemplateType templateType;
    private Optional<Boolean> paginated = Optional.empty();
    private Optional<Long> limit = Utils.readDefaultOrConstValue("limit", "10", new TypeReference<Optional<Long>>(){});
    private Optional<Long> offset = Utils.readDefaultOrConstValue("offset", "0", new TypeReference<Optional<Long>>(){});
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Limit = new LazySingletonValue<Optional<Long>>("limit", "10", new TypeReference<Optional<Long>>(){});
    private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Offset = new LazySingletonValue<Optional<Long>>("offset", "0", new TypeReference<Optional<Long>>(){});

    public GetTemplateListRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public GetTemplateListRequestBuilder templateType(TemplateType templateType) {
        Utils.checkNotNull(templateType, "templateType");
        this.templateType = templateType;
        return this;
    }

    public GetTemplateListRequestBuilder paginated(boolean paginated) {
        Utils.checkNotNull(paginated, "paginated");
        this.paginated = Optional.of(paginated);
        return this;
    }

    public GetTemplateListRequestBuilder paginated(Optional<Boolean> paginated) {
        Utils.checkNotNull(paginated, "paginated");
        this.paginated = paginated;
        return this;
    }

    public GetTemplateListRequestBuilder limit(long limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.of(limit);
        return this;
    }

    public GetTemplateListRequestBuilder limit(Optional<Long> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public GetTemplateListRequestBuilder offset(long offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = Optional.of(offset);
        return this;
    }

    public GetTemplateListRequestBuilder offset(Optional<Long> offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = offset;
        return this;
    }

    public GetTemplateListRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public GetTemplateListRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private GetTemplateListRequest buildRequest() {
        if (this.limit == null) {
            this.limit = _SINGLETON_VALUE_Limit.value();
        }
        if (this.offset == null) {
            this.offset = _SINGLETON_VALUE_Offset.value();
        }
        GetTemplateListRequest request = new GetTemplateListRequest(this.templateType, this.paginated, this.limit, this.offset);
        return request;
    }

    public GetTemplateListResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        GetTemplateList.Sync operation = new GetTemplateList.Sync(this.sdkConfiguration, options);
        GetTemplateListRequest request = this.buildRequest();
        return (GetTemplateListResponse)operation.handleResponse(operation.doRequest(request));
    }
}

