/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.Template;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Optional;

public class GetTemplateListResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends List<Template>> templateList;

    @JsonCreator
    public GetTemplateListResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends List<Template>> templateList) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(templateList, "templateList");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.templateList = templateList;
    }

    public GetTemplateListResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<List<Template>> templateList() {
        return this.templateList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public GetTemplateListResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public GetTemplateListResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public GetTemplateListResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public GetTemplateListResponse withTemplateList(List<Template> templateList) {
        Utils.checkNotNull(templateList, "templateList");
        this.templateList = Optional.ofNullable(templateList);
        return this;
    }

    public GetTemplateListResponse withTemplateList(Optional<? extends List<Template>> templateList) {
        Utils.checkNotNull(templateList, "templateList");
        this.templateList = templateList;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTemplateListResponse other = (GetTemplateListResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.templateList, other.templateList);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.templateList);
    }

    public String toString() {
        return Utils.toString(GetTemplateListResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "templateList", this.templateList);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends List<Template>> templateList = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder templateList(List<Template> templateList) {
            Utils.checkNotNull(templateList, "templateList");
            this.templateList = Optional.ofNullable(templateList);
            return this;
        }

        public Builder templateList(Optional<? extends List<Template>> templateList) {
            Utils.checkNotNull(templateList, "templateList");
            this.templateList = templateList;
            return this;
        }

        public GetTemplateListResponse build() {
            return new GetTemplateListResponse(this.contentType, this.statusCode, this.rawResponse, this.templateList);
        }
    }
}

