/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.PathParamTemplateType;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class GetTemplateRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=template_type")
    private PathParamTemplateType templateType;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=slug")
    private String slug;

    @JsonCreator
    public GetTemplateRequest(PathParamTemplateType templateType, String slug) {
        Utils.checkNotNull(templateType, "templateType");
        Utils.checkNotNull(slug, "slug");
        this.templateType = templateType;
        this.slug = slug;
    }

    @JsonIgnore
    public PathParamTemplateType templateType() {
        return this.templateType;
    }

    @JsonIgnore
    public String slug() {
        return this.slug;
    }

    public static Builder builder() {
        return new Builder();
    }

    public GetTemplateRequest withTemplateType(PathParamTemplateType templateType) {
        Utils.checkNotNull(templateType, "templateType");
        this.templateType = templateType;
        return this;
    }

    public GetTemplateRequest withSlug(String slug) {
        Utils.checkNotNull(slug, "slug");
        this.slug = slug;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTemplateRequest other = (GetTemplateRequest)o;
        return Utils.enhancedDeepEquals((Object)this.templateType, (Object)other.templateType) && Utils.enhancedDeepEquals(this.slug, other.slug);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.templateType, this.slug});
    }

    public String toString() {
        return Utils.toString(GetTemplateRequest.class, new Object[]{"templateType", this.templateType, "slug", this.slug});
    }

    public static final class Builder {
        private PathParamTemplateType templateType;
        private String slug;

        private Builder() {
        }

        public Builder templateType(PathParamTemplateType templateType) {
            Utils.checkNotNull(templateType, "templateType");
            this.templateType = templateType;
            return this;
        }

        public Builder slug(String slug) {
            Utils.checkNotNull(slug, "slug");
            this.slug = slug;
            return this;
        }

        public GetTemplateRequest build() {
            return new GetTemplateRequest(this.templateType, this.slug);
        }
    }
}

