/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.GetUserBillingSubscriptionRequest;
import com.clerk.backend_api.models.operations.GetUserBillingSubscriptionResponse;
import com.clerk.backend_api.operations.GetUserBillingSubscription;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class GetUserBillingSubscriptionRequestBuilder {
    private String userId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public GetUserBillingSubscriptionRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public GetUserBillingSubscriptionRequestBuilder userId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public GetUserBillingSubscriptionRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public GetUserBillingSubscriptionRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private GetUserBillingSubscriptionRequest buildRequest() {
        GetUserBillingSubscriptionRequest request = new GetUserBillingSubscriptionRequest(this.userId);
        return request;
    }

    public GetUserBillingSubscriptionResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        GetUserBillingSubscription.Sync operation = new GetUserBillingSubscription.Sync(this.sdkConfiguration, options);
        GetUserBillingSubscriptionRequest request = this.buildRequest();
        return (GetUserBillingSubscriptionResponse)operation.handleResponse(operation.doRequest(request));
    }
}

