/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.CommerceSubscription;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class GetUserBillingSubscriptionResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends CommerceSubscription> commerceSubscription;

    @JsonCreator
    public GetUserBillingSubscriptionResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends CommerceSubscription> commerceSubscription) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(commerceSubscription, "commerceSubscription");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.commerceSubscription = commerceSubscription;
    }

    public GetUserBillingSubscriptionResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<CommerceSubscription> commerceSubscription() {
        return this.commerceSubscription;
    }

    public static Builder builder() {
        return new Builder();
    }

    public GetUserBillingSubscriptionResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public GetUserBillingSubscriptionResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public GetUserBillingSubscriptionResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public GetUserBillingSubscriptionResponse withCommerceSubscription(CommerceSubscription commerceSubscription) {
        Utils.checkNotNull(commerceSubscription, "commerceSubscription");
        this.commerceSubscription = Optional.ofNullable(commerceSubscription);
        return this;
    }

    public GetUserBillingSubscriptionResponse withCommerceSubscription(Optional<? extends CommerceSubscription> commerceSubscription) {
        Utils.checkNotNull(commerceSubscription, "commerceSubscription");
        this.commerceSubscription = commerceSubscription;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetUserBillingSubscriptionResponse other = (GetUserBillingSubscriptionResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.commerceSubscription, other.commerceSubscription);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.commerceSubscription);
    }

    public String toString() {
        return Utils.toString(GetUserBillingSubscriptionResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "commerceSubscription", this.commerceSubscription);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends CommerceSubscription> commerceSubscription = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder commerceSubscription(CommerceSubscription commerceSubscription) {
            Utils.checkNotNull(commerceSubscription, "commerceSubscription");
            this.commerceSubscription = Optional.ofNullable(commerceSubscription);
            return this;
        }

        public Builder commerceSubscription(Optional<? extends CommerceSubscription> commerceSubscription) {
            Utils.checkNotNull(commerceSubscription, "commerceSubscription");
            this.commerceSubscription = commerceSubscription;
            return this;
        }

        public GetUserBillingSubscriptionResponse build() {
            return new GetUserBillingSubscriptionResponse(this.contentType, this.statusCode, this.rawResponse, this.commerceSubscription);
        }
    }
}

