/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.InstanceGetOrganizationMembershipsRequest;
import com.clerk.backend_api.models.operations.InstanceGetOrganizationMembershipsResponse;
import com.clerk.backend_api.operations.InstanceGetOrganizationMemberships;
import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Optional;

public class InstanceGetOrganizationMembershipsRequestBuilder {
    private Optional<String> orderBy = Optional.empty();
    private Optional<Long> limit = Utils.readDefaultOrConstValue("limit", "10", new TypeReference<Optional<Long>>(){});
    private Optional<Long> offset = Utils.readDefaultOrConstValue("offset", "0", new TypeReference<Optional<Long>>(){});
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Limit = new LazySingletonValue<Optional<Long>>("limit", "10", new TypeReference<Optional<Long>>(){});
    private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Offset = new LazySingletonValue<Optional<Long>>("offset", "0", new TypeReference<Optional<Long>>(){});

    public InstanceGetOrganizationMembershipsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public InstanceGetOrganizationMembershipsRequestBuilder orderBy(String orderBy) {
        Utils.checkNotNull(orderBy, "orderBy");
        this.orderBy = Optional.of(orderBy);
        return this;
    }

    public InstanceGetOrganizationMembershipsRequestBuilder orderBy(Optional<String> orderBy) {
        Utils.checkNotNull(orderBy, "orderBy");
        this.orderBy = orderBy;
        return this;
    }

    public InstanceGetOrganizationMembershipsRequestBuilder limit(long limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.of(limit);
        return this;
    }

    public InstanceGetOrganizationMembershipsRequestBuilder limit(Optional<Long> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public InstanceGetOrganizationMembershipsRequestBuilder offset(long offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = Optional.of(offset);
        return this;
    }

    public InstanceGetOrganizationMembershipsRequestBuilder offset(Optional<Long> offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = offset;
        return this;
    }

    public InstanceGetOrganizationMembershipsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public InstanceGetOrganizationMembershipsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private InstanceGetOrganizationMembershipsRequest buildRequest() {
        if (this.limit == null) {
            this.limit = _SINGLETON_VALUE_Limit.value();
        }
        if (this.offset == null) {
            this.offset = _SINGLETON_VALUE_Offset.value();
        }
        InstanceGetOrganizationMembershipsRequest request = new InstanceGetOrganizationMembershipsRequest(this.orderBy, this.limit, this.offset);
        return request;
    }

    public InstanceGetOrganizationMembershipsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        InstanceGetOrganizationMemberships.Sync operation = new InstanceGetOrganizationMemberships.Sync(this.sdkConfiguration, options);
        InstanceGetOrganizationMembershipsRequest request = this.buildRequest();
        return (InstanceGetOrganizationMembershipsResponse)operation.handleResponse(operation.doRequest(request));
    }
}

