/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.InviteWaitlistEntryRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;

public class InviteWaitlistEntryRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=waitlist_entry_id")
    private String waitlistEntryId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private Optional<? extends InviteWaitlistEntryRequestBody> requestBody;

    @JsonCreator
    public InviteWaitlistEntryRequest(String waitlistEntryId, Optional<? extends InviteWaitlistEntryRequestBody> requestBody) {
        Utils.checkNotNull(waitlistEntryId, "waitlistEntryId");
        Utils.checkNotNull(requestBody, "requestBody");
        this.waitlistEntryId = waitlistEntryId;
        this.requestBody = requestBody;
    }

    public InviteWaitlistEntryRequest(String waitlistEntryId) {
        this(waitlistEntryId, Optional.empty());
    }

    @JsonIgnore
    public String waitlistEntryId() {
        return this.waitlistEntryId;
    }

    @JsonIgnore
    public Optional<InviteWaitlistEntryRequestBody> requestBody() {
        return this.requestBody;
    }

    public static Builder builder() {
        return new Builder();
    }

    public InviteWaitlistEntryRequest withWaitlistEntryId(String waitlistEntryId) {
        Utils.checkNotNull(waitlistEntryId, "waitlistEntryId");
        this.waitlistEntryId = waitlistEntryId;
        return this;
    }

    public InviteWaitlistEntryRequest withRequestBody(InviteWaitlistEntryRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.ofNullable(requestBody);
        return this;
    }

    public InviteWaitlistEntryRequest withRequestBody(Optional<? extends InviteWaitlistEntryRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InviteWaitlistEntryRequest other = (InviteWaitlistEntryRequest)o;
        return Utils.enhancedDeepEquals(this.waitlistEntryId, other.waitlistEntryId) && Utils.enhancedDeepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.waitlistEntryId, this.requestBody);
    }

    public String toString() {
        return Utils.toString(InviteWaitlistEntryRequest.class, "waitlistEntryId", this.waitlistEntryId, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String waitlistEntryId;
        private Optional<? extends InviteWaitlistEntryRequestBody> requestBody = Optional.empty();

        private Builder() {
        }

        public Builder waitlistEntryId(String waitlistEntryId) {
            Utils.checkNotNull(waitlistEntryId, "waitlistEntryId");
            this.waitlistEntryId = waitlistEntryId;
            return this;
        }

        public Builder requestBody(InviteWaitlistEntryRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = Optional.ofNullable(requestBody);
            return this;
        }

        public Builder requestBody(Optional<? extends InviteWaitlistEntryRequestBody> requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public InviteWaitlistEntryRequest build() {
            return new InviteWaitlistEntryRequest(this.waitlistEntryId, this.requestBody);
        }
    }
}

