/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.InviteWaitlistEntryRequest;
import com.clerk.backend_api.models.operations.InviteWaitlistEntryRequestBody;
import com.clerk.backend_api.models.operations.InviteWaitlistEntryResponse;
import com.clerk.backend_api.operations.InviteWaitlistEntry;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class InviteWaitlistEntryRequestBuilder {
    private String waitlistEntryId;
    private Optional<? extends InviteWaitlistEntryRequestBody> requestBody = Optional.empty();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public InviteWaitlistEntryRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public InviteWaitlistEntryRequestBuilder waitlistEntryId(String waitlistEntryId) {
        Utils.checkNotNull(waitlistEntryId, "waitlistEntryId");
        this.waitlistEntryId = waitlistEntryId;
        return this;
    }

    public InviteWaitlistEntryRequestBuilder requestBody(InviteWaitlistEntryRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.of(requestBody);
        return this;
    }

    public InviteWaitlistEntryRequestBuilder requestBody(Optional<? extends InviteWaitlistEntryRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public InviteWaitlistEntryRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public InviteWaitlistEntryRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private InviteWaitlistEntryRequest buildRequest() {
        InviteWaitlistEntryRequest request = new InviteWaitlistEntryRequest(this.waitlistEntryId, this.requestBody);
        return request;
    }

    public InviteWaitlistEntryResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        InviteWaitlistEntry.Sync operation = new InviteWaitlistEntry.Sync(this.sdkConfiguration, options);
        InviteWaitlistEntryRequest request = this.buildRequest();
        return (InviteWaitlistEntryResponse)operation.handleResponse(operation.doRequest(request));
    }
}

