/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.EnrollmentMode;
import com.clerk.backend_api.models.operations.Verified;
import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Optional;

public class ListAllOrganizationDomainsRequest {
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=organization_id")
    private Optional<String> organizationId;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=verified")
    private Optional<? extends Verified> verified;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=false,name=enrollment_mode")
    private Optional<? extends List<EnrollmentMode>> enrollmentMode;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=query")
    private Optional<String> query;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=order_by")
    private Optional<String> orderBy;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=offset")
    private Optional<Long> offset;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=limit")
    private Optional<Long> limit;

    @JsonCreator
    public ListAllOrganizationDomainsRequest(Optional<String> organizationId, Optional<? extends Verified> verified, Optional<? extends List<EnrollmentMode>> enrollmentMode, Optional<String> query, Optional<String> orderBy, Optional<Long> offset, Optional<Long> limit) {
        Utils.checkNotNull(organizationId, "organizationId");
        Utils.checkNotNull(verified, "verified");
        Utils.checkNotNull(enrollmentMode, "enrollmentMode");
        Utils.checkNotNull(query, "query");
        Utils.checkNotNull(orderBy, "orderBy");
        Utils.checkNotNull(offset, "offset");
        Utils.checkNotNull(limit, "limit");
        this.organizationId = organizationId;
        this.verified = verified;
        this.enrollmentMode = enrollmentMode;
        this.query = query;
        this.orderBy = orderBy;
        this.offset = offset;
        this.limit = limit;
    }

    public ListAllOrganizationDomainsRequest() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> organizationId() {
        return this.organizationId;
    }

    @JsonIgnore
    public Optional<Verified> verified() {
        return this.verified;
    }

    @JsonIgnore
    public Optional<List<EnrollmentMode>> enrollmentMode() {
        return this.enrollmentMode;
    }

    @JsonIgnore
    public Optional<String> query() {
        return this.query;
    }

    @JsonIgnore
    public Optional<String> orderBy() {
        return this.orderBy;
    }

    @JsonIgnore
    public Optional<Long> offset() {
        return this.offset;
    }

    @JsonIgnore
    public Optional<Long> limit() {
        return this.limit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ListAllOrganizationDomainsRequest withOrganizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = Optional.ofNullable(organizationId);
        return this;
    }

    public ListAllOrganizationDomainsRequest withOrganizationId(Optional<String> organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public ListAllOrganizationDomainsRequest withVerified(Verified verified) {
        Utils.checkNotNull(verified, "verified");
        this.verified = Optional.ofNullable(verified);
        return this;
    }

    public ListAllOrganizationDomainsRequest withVerified(Optional<? extends Verified> verified) {
        Utils.checkNotNull(verified, "verified");
        this.verified = verified;
        return this;
    }

    public ListAllOrganizationDomainsRequest withEnrollmentMode(List<EnrollmentMode> enrollmentMode) {
        Utils.checkNotNull(enrollmentMode, "enrollmentMode");
        this.enrollmentMode = Optional.ofNullable(enrollmentMode);
        return this;
    }

    public ListAllOrganizationDomainsRequest withEnrollmentMode(Optional<? extends List<EnrollmentMode>> enrollmentMode) {
        Utils.checkNotNull(enrollmentMode, "enrollmentMode");
        this.enrollmentMode = enrollmentMode;
        return this;
    }

    public ListAllOrganizationDomainsRequest withQuery(String query) {
        Utils.checkNotNull(query, "query");
        this.query = Optional.ofNullable(query);
        return this;
    }

    public ListAllOrganizationDomainsRequest withQuery(Optional<String> query) {
        Utils.checkNotNull(query, "query");
        this.query = query;
        return this;
    }

    public ListAllOrganizationDomainsRequest withOrderBy(String orderBy) {
        Utils.checkNotNull(orderBy, "orderBy");
        this.orderBy = Optional.ofNullable(orderBy);
        return this;
    }

    public ListAllOrganizationDomainsRequest withOrderBy(Optional<String> orderBy) {
        Utils.checkNotNull(orderBy, "orderBy");
        this.orderBy = orderBy;
        return this;
    }

    public ListAllOrganizationDomainsRequest withOffset(long offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = Optional.ofNullable(offset);
        return this;
    }

    public ListAllOrganizationDomainsRequest withOffset(Optional<Long> offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = offset;
        return this;
    }

    public ListAllOrganizationDomainsRequest withLimit(long limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.ofNullable(limit);
        return this;
    }

    public ListAllOrganizationDomainsRequest withLimit(Optional<Long> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListAllOrganizationDomainsRequest other = (ListAllOrganizationDomainsRequest)o;
        return Utils.enhancedDeepEquals(this.organizationId, other.organizationId) && Utils.enhancedDeepEquals(this.verified, other.verified) && Utils.enhancedDeepEquals(this.enrollmentMode, other.enrollmentMode) && Utils.enhancedDeepEquals(this.query, other.query) && Utils.enhancedDeepEquals(this.orderBy, other.orderBy) && Utils.enhancedDeepEquals(this.offset, other.offset) && Utils.enhancedDeepEquals(this.limit, other.limit);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.organizationId, this.verified, this.enrollmentMode, this.query, this.orderBy, this.offset, this.limit);
    }

    public String toString() {
        return Utils.toString(ListAllOrganizationDomainsRequest.class, "organizationId", this.organizationId, "verified", this.verified, "enrollmentMode", this.enrollmentMode, "query", this.query, "orderBy", this.orderBy, "offset", this.offset, "limit", this.limit);
    }

    public static final class Builder {
        private Optional<String> organizationId = Optional.empty();
        private Optional<? extends Verified> verified = Optional.empty();
        private Optional<? extends List<EnrollmentMode>> enrollmentMode = Optional.empty();
        private Optional<String> query = Optional.empty();
        private Optional<String> orderBy;
        private Optional<Long> offset;
        private Optional<Long> limit;
        private static final LazySingletonValue<Optional<String>> _SINGLETON_VALUE_OrderBy = new LazySingletonValue<Optional<String>>("order_by", "\"-created_at\"", new TypeReference<Optional<String>>(){});
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Offset = new LazySingletonValue<Optional<Long>>("offset", "0", new TypeReference<Optional<Long>>(){});
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Limit = new LazySingletonValue<Optional<Long>>("limit", "10", new TypeReference<Optional<Long>>(){});

        private Builder() {
        }

        public Builder organizationId(String organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = Optional.ofNullable(organizationId);
            return this;
        }

        public Builder organizationId(Optional<String> organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = organizationId;
            return this;
        }

        public Builder verified(Verified verified) {
            Utils.checkNotNull(verified, "verified");
            this.verified = Optional.ofNullable(verified);
            return this;
        }

        public Builder verified(Optional<? extends Verified> verified) {
            Utils.checkNotNull(verified, "verified");
            this.verified = verified;
            return this;
        }

        public Builder enrollmentMode(List<EnrollmentMode> enrollmentMode) {
            Utils.checkNotNull(enrollmentMode, "enrollmentMode");
            this.enrollmentMode = Optional.ofNullable(enrollmentMode);
            return this;
        }

        public Builder enrollmentMode(Optional<? extends List<EnrollmentMode>> enrollmentMode) {
            Utils.checkNotNull(enrollmentMode, "enrollmentMode");
            this.enrollmentMode = enrollmentMode;
            return this;
        }

        public Builder query(String query) {
            Utils.checkNotNull(query, "query");
            this.query = Optional.ofNullable(query);
            return this;
        }

        public Builder query(Optional<String> query) {
            Utils.checkNotNull(query, "query");
            this.query = query;
            return this;
        }

        public Builder orderBy(String orderBy) {
            Utils.checkNotNull(orderBy, "orderBy");
            this.orderBy = Optional.ofNullable(orderBy);
            return this;
        }

        public Builder orderBy(Optional<String> orderBy) {
            Utils.checkNotNull(orderBy, "orderBy");
            this.orderBy = orderBy;
            return this;
        }

        public Builder offset(long offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public Builder offset(Optional<Long> offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = offset;
            return this;
        }

        public Builder limit(long limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public Builder limit(Optional<Long> limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = limit;
            return this;
        }

        public ListAllOrganizationDomainsRequest build() {
            if (this.orderBy == null) {
                this.orderBy = _SINGLETON_VALUE_OrderBy.value();
            }
            if (this.offset == null) {
                this.offset = _SINGLETON_VALUE_Offset.value();
            }
            if (this.limit == null) {
                this.limit = _SINGLETON_VALUE_Limit.value();
            }
            return new ListAllOrganizationDomainsRequest(this.organizationId, this.verified, this.enrollmentMode, this.query, this.orderBy, this.offset, this.limit);
        }
    }
}

