/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.ListAllowlistIdentifiersRequest;
import com.clerk.backend_api.models.operations.ListAllowlistIdentifiersResponse;
import com.clerk.backend_api.operations.ListAllowlistIdentifiers;
import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Optional;

public class ListAllowlistIdentifiersRequestBuilder {
    private Optional<Boolean> paginated = Optional.empty();
    private Optional<Long> limit = Utils.readDefaultOrConstValue("limit", "10", new TypeReference<Optional<Long>>(){});
    private Optional<Long> offset = Utils.readDefaultOrConstValue("offset", "0", new TypeReference<Optional<Long>>(){});
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Limit = new LazySingletonValue<Optional<Long>>("limit", "10", new TypeReference<Optional<Long>>(){});
    private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Offset = new LazySingletonValue<Optional<Long>>("offset", "0", new TypeReference<Optional<Long>>(){});

    public ListAllowlistIdentifiersRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public ListAllowlistIdentifiersRequestBuilder paginated(boolean paginated) {
        Utils.checkNotNull(paginated, "paginated");
        this.paginated = Optional.of(paginated);
        return this;
    }

    public ListAllowlistIdentifiersRequestBuilder paginated(Optional<Boolean> paginated) {
        Utils.checkNotNull(paginated, "paginated");
        this.paginated = paginated;
        return this;
    }

    public ListAllowlistIdentifiersRequestBuilder limit(long limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.of(limit);
        return this;
    }

    public ListAllowlistIdentifiersRequestBuilder limit(Optional<Long> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public ListAllowlistIdentifiersRequestBuilder offset(long offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = Optional.of(offset);
        return this;
    }

    public ListAllowlistIdentifiersRequestBuilder offset(Optional<Long> offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = offset;
        return this;
    }

    public ListAllowlistIdentifiersRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public ListAllowlistIdentifiersRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private ListAllowlistIdentifiersRequest buildRequest() {
        if (this.limit == null) {
            this.limit = _SINGLETON_VALUE_Limit.value();
        }
        if (this.offset == null) {
            this.offset = _SINGLETON_VALUE_Offset.value();
        }
        ListAllowlistIdentifiersRequest request = new ListAllowlistIdentifiersRequest(this.paginated, this.limit, this.offset);
        return request;
    }

    public ListAllowlistIdentifiersResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        ListAllowlistIdentifiers.Sync operation = new ListAllowlistIdentifiers.Sync(this.sdkConfiguration, options);
        ListAllowlistIdentifiersRequest request = this.buildRequest();
        return (ListAllowlistIdentifiersResponse)operation.handleResponse(operation.doRequest(request));
    }
}

