/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.BlocklistIdentifiers;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class ListBlocklistIdentifiersResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends BlocklistIdentifiers> blocklistIdentifiers;

    @JsonCreator
    public ListBlocklistIdentifiersResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends BlocklistIdentifiers> blocklistIdentifiers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(blocklistIdentifiers, "blocklistIdentifiers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.blocklistIdentifiers = blocklistIdentifiers;
    }

    public ListBlocklistIdentifiersResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<BlocklistIdentifiers> blocklistIdentifiers() {
        return this.blocklistIdentifiers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ListBlocklistIdentifiersResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public ListBlocklistIdentifiersResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public ListBlocklistIdentifiersResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public ListBlocklistIdentifiersResponse withBlocklistIdentifiers(BlocklistIdentifiers blocklistIdentifiers) {
        Utils.checkNotNull(blocklistIdentifiers, "blocklistIdentifiers");
        this.blocklistIdentifiers = Optional.ofNullable(blocklistIdentifiers);
        return this;
    }

    public ListBlocklistIdentifiersResponse withBlocklistIdentifiers(Optional<? extends BlocklistIdentifiers> blocklistIdentifiers) {
        Utils.checkNotNull(blocklistIdentifiers, "blocklistIdentifiers");
        this.blocklistIdentifiers = blocklistIdentifiers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListBlocklistIdentifiersResponse other = (ListBlocklistIdentifiersResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.blocklistIdentifiers, other.blocklistIdentifiers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.blocklistIdentifiers);
    }

    public String toString() {
        return Utils.toString(ListBlocklistIdentifiersResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "blocklistIdentifiers", this.blocklistIdentifiers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends BlocklistIdentifiers> blocklistIdentifiers = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder blocklistIdentifiers(BlocklistIdentifiers blocklistIdentifiers) {
            Utils.checkNotNull(blocklistIdentifiers, "blocklistIdentifiers");
            this.blocklistIdentifiers = Optional.ofNullable(blocklistIdentifiers);
            return this;
        }

        public Builder blocklistIdentifiers(Optional<? extends BlocklistIdentifiers> blocklistIdentifiers) {
            Utils.checkNotNull(blocklistIdentifiers, "blocklistIdentifiers");
            this.blocklistIdentifiers = blocklistIdentifiers;
            return this;
        }

        public ListBlocklistIdentifiersResponse build() {
            return new ListBlocklistIdentifiersResponse(this.contentType, this.statusCode, this.rawResponse, this.blocklistIdentifiers);
        }
    }
}

