/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.ListInstanceOrganizationInvitationsQueryParamStatus;
import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Optional;

public class ListInstanceOrganizationInvitationsRequest {
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=order_by")
    private Optional<String> orderBy;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=status")
    private Optional<? extends ListInstanceOrganizationInvitationsQueryParamStatus> status;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=query")
    private Optional<String> query;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=limit")
    private Optional<Long> limit;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=offset")
    private Optional<Long> offset;

    @JsonCreator
    public ListInstanceOrganizationInvitationsRequest(Optional<String> orderBy, Optional<? extends ListInstanceOrganizationInvitationsQueryParamStatus> status, Optional<String> query, Optional<Long> limit, Optional<Long> offset) {
        Utils.checkNotNull(orderBy, "orderBy");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(query, "query");
        Utils.checkNotNull(limit, "limit");
        Utils.checkNotNull(offset, "offset");
        this.orderBy = orderBy;
        this.status = status;
        this.query = query;
        this.limit = limit;
        this.offset = offset;
    }

    public ListInstanceOrganizationInvitationsRequest() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> orderBy() {
        return this.orderBy;
    }

    @JsonIgnore
    public Optional<ListInstanceOrganizationInvitationsQueryParamStatus> status() {
        return this.status;
    }

    @JsonIgnore
    public Optional<String> query() {
        return this.query;
    }

    @JsonIgnore
    public Optional<Long> limit() {
        return this.limit;
    }

    @JsonIgnore
    public Optional<Long> offset() {
        return this.offset;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ListInstanceOrganizationInvitationsRequest withOrderBy(String orderBy) {
        Utils.checkNotNull(orderBy, "orderBy");
        this.orderBy = Optional.ofNullable(orderBy);
        return this;
    }

    public ListInstanceOrganizationInvitationsRequest withOrderBy(Optional<String> orderBy) {
        Utils.checkNotNull(orderBy, "orderBy");
        this.orderBy = orderBy;
        return this;
    }

    public ListInstanceOrganizationInvitationsRequest withStatus(ListInstanceOrganizationInvitationsQueryParamStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = Optional.ofNullable(status);
        return this;
    }

    public ListInstanceOrganizationInvitationsRequest withStatus(Optional<? extends ListInstanceOrganizationInvitationsQueryParamStatus> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public ListInstanceOrganizationInvitationsRequest withQuery(String query) {
        Utils.checkNotNull(query, "query");
        this.query = Optional.ofNullable(query);
        return this;
    }

    public ListInstanceOrganizationInvitationsRequest withQuery(Optional<String> query) {
        Utils.checkNotNull(query, "query");
        this.query = query;
        return this;
    }

    public ListInstanceOrganizationInvitationsRequest withLimit(long limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.ofNullable(limit);
        return this;
    }

    public ListInstanceOrganizationInvitationsRequest withLimit(Optional<Long> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public ListInstanceOrganizationInvitationsRequest withOffset(long offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = Optional.ofNullable(offset);
        return this;
    }

    public ListInstanceOrganizationInvitationsRequest withOffset(Optional<Long> offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = offset;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListInstanceOrganizationInvitationsRequest other = (ListInstanceOrganizationInvitationsRequest)o;
        return Utils.enhancedDeepEquals(this.orderBy, other.orderBy) && Utils.enhancedDeepEquals(this.status, other.status) && Utils.enhancedDeepEquals(this.query, other.query) && Utils.enhancedDeepEquals(this.limit, other.limit) && Utils.enhancedDeepEquals(this.offset, other.offset);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.orderBy, this.status, this.query, this.limit, this.offset);
    }

    public String toString() {
        return Utils.toString(ListInstanceOrganizationInvitationsRequest.class, "orderBy", this.orderBy, "status", this.status, "query", this.query, "limit", this.limit, "offset", this.offset);
    }

    public static final class Builder {
        private Optional<String> orderBy;
        private Optional<? extends ListInstanceOrganizationInvitationsQueryParamStatus> status = Optional.empty();
        private Optional<String> query = Optional.empty();
        private Optional<Long> limit;
        private Optional<Long> offset;
        private static final LazySingletonValue<Optional<String>> _SINGLETON_VALUE_OrderBy = new LazySingletonValue<Optional<String>>("order_by", "\"-created_at\"", new TypeReference<Optional<String>>(){});
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Limit = new LazySingletonValue<Optional<Long>>("limit", "10", new TypeReference<Optional<Long>>(){});
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Offset = new LazySingletonValue<Optional<Long>>("offset", "0", new TypeReference<Optional<Long>>(){});

        private Builder() {
        }

        public Builder orderBy(String orderBy) {
            Utils.checkNotNull(orderBy, "orderBy");
            this.orderBy = Optional.ofNullable(orderBy);
            return this;
        }

        public Builder orderBy(Optional<String> orderBy) {
            Utils.checkNotNull(orderBy, "orderBy");
            this.orderBy = orderBy;
            return this;
        }

        public Builder status(ListInstanceOrganizationInvitationsQueryParamStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = Optional.ofNullable(status);
            return this;
        }

        public Builder status(Optional<? extends ListInstanceOrganizationInvitationsQueryParamStatus> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder query(String query) {
            Utils.checkNotNull(query, "query");
            this.query = Optional.ofNullable(query);
            return this;
        }

        public Builder query(Optional<String> query) {
            Utils.checkNotNull(query, "query");
            this.query = query;
            return this;
        }

        public Builder limit(long limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public Builder limit(Optional<Long> limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = limit;
            return this;
        }

        public Builder offset(long offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public Builder offset(Optional<Long> offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = offset;
            return this;
        }

        public ListInstanceOrganizationInvitationsRequest build() {
            if (this.orderBy == null) {
                this.orderBy = _SINGLETON_VALUE_OrderBy.value();
            }
            if (this.limit == null) {
                this.limit = _SINGLETON_VALUE_Limit.value();
            }
            if (this.offset == null) {
                this.offset = _SINGLETON_VALUE_Offset.value();
            }
            return new ListInstanceOrganizationInvitationsRequest(this.orderBy, this.status, this.query, this.limit, this.offset);
        }
    }
}

