/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Optional;

public class ListMachinesRequest {
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=limit")
    private Optional<Long> limit;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=offset")
    private Optional<Long> offset;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=query")
    private Optional<String> query;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=order_by")
    private Optional<String> orderBy;

    @JsonCreator
    public ListMachinesRequest(Optional<Long> limit, Optional<Long> offset, Optional<String> query, Optional<String> orderBy) {
        Utils.checkNotNull(limit, "limit");
        Utils.checkNotNull(offset, "offset");
        Utils.checkNotNull(query, "query");
        Utils.checkNotNull(orderBy, "orderBy");
        this.limit = limit;
        this.offset = offset;
        this.query = query;
        this.orderBy = orderBy;
    }

    public ListMachinesRequest() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<Long> limit() {
        return this.limit;
    }

    @JsonIgnore
    public Optional<Long> offset() {
        return this.offset;
    }

    @JsonIgnore
    public Optional<String> query() {
        return this.query;
    }

    @JsonIgnore
    public Optional<String> orderBy() {
        return this.orderBy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ListMachinesRequest withLimit(long limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.ofNullable(limit);
        return this;
    }

    public ListMachinesRequest withLimit(Optional<Long> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public ListMachinesRequest withOffset(long offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = Optional.ofNullable(offset);
        return this;
    }

    public ListMachinesRequest withOffset(Optional<Long> offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = offset;
        return this;
    }

    public ListMachinesRequest withQuery(String query) {
        Utils.checkNotNull(query, "query");
        this.query = Optional.ofNullable(query);
        return this;
    }

    public ListMachinesRequest withQuery(Optional<String> query) {
        Utils.checkNotNull(query, "query");
        this.query = query;
        return this;
    }

    public ListMachinesRequest withOrderBy(String orderBy) {
        Utils.checkNotNull(orderBy, "orderBy");
        this.orderBy = Optional.ofNullable(orderBy);
        return this;
    }

    public ListMachinesRequest withOrderBy(Optional<String> orderBy) {
        Utils.checkNotNull(orderBy, "orderBy");
        this.orderBy = orderBy;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListMachinesRequest other = (ListMachinesRequest)o;
        return Utils.enhancedDeepEquals(this.limit, other.limit) && Utils.enhancedDeepEquals(this.offset, other.offset) && Utils.enhancedDeepEquals(this.query, other.query) && Utils.enhancedDeepEquals(this.orderBy, other.orderBy);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.limit, this.offset, this.query, this.orderBy);
    }

    public String toString() {
        return Utils.toString(ListMachinesRequest.class, "limit", this.limit, "offset", this.offset, "query", this.query, "orderBy", this.orderBy);
    }

    public static final class Builder {
        private Optional<Long> limit;
        private Optional<Long> offset;
        private Optional<String> query = Optional.empty();
        private Optional<String> orderBy;
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Limit = new LazySingletonValue<Optional<Long>>("limit", "10", new TypeReference<Optional<Long>>(){});
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Offset = new LazySingletonValue<Optional<Long>>("offset", "0", new TypeReference<Optional<Long>>(){});
        private static final LazySingletonValue<Optional<String>> _SINGLETON_VALUE_OrderBy = new LazySingletonValue<Optional<String>>("order_by", "\"-created_at\"", new TypeReference<Optional<String>>(){});

        private Builder() {
        }

        public Builder limit(long limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public Builder limit(Optional<Long> limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = limit;
            return this;
        }

        public Builder offset(long offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public Builder offset(Optional<Long> offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = offset;
            return this;
        }

        public Builder query(String query) {
            Utils.checkNotNull(query, "query");
            this.query = Optional.ofNullable(query);
            return this;
        }

        public Builder query(Optional<String> query) {
            Utils.checkNotNull(query, "query");
            this.query = query;
            return this;
        }

        public Builder orderBy(String orderBy) {
            Utils.checkNotNull(orderBy, "orderBy");
            this.orderBy = Optional.ofNullable(orderBy);
            return this;
        }

        public Builder orderBy(Optional<String> orderBy) {
            Utils.checkNotNull(orderBy, "orderBy");
            this.orderBy = orderBy;
            return this;
        }

        public ListMachinesRequest build() {
            if (this.limit == null) {
                this.limit = _SINGLETON_VALUE_Limit.value();
            }
            if (this.offset == null) {
                this.offset = _SINGLETON_VALUE_Offset.value();
            }
            if (this.orderBy == null) {
                this.orderBy = _SINGLETON_VALUE_OrderBy.value();
            }
            return new ListMachinesRequest(this.limit, this.offset, this.query, this.orderBy);
        }
    }
}

