/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Optional;

public class ListOAuthApplicationsRequest {
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=limit")
    private Optional<Long> limit;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=offset")
    private Optional<Long> offset;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=order_by")
    private Optional<String> orderBy;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=name_query")
    private Optional<String> nameQuery;

    @JsonCreator
    public ListOAuthApplicationsRequest(Optional<Long> limit, Optional<Long> offset, Optional<String> orderBy, Optional<String> nameQuery) {
        Utils.checkNotNull(limit, "limit");
        Utils.checkNotNull(offset, "offset");
        Utils.checkNotNull(orderBy, "orderBy");
        Utils.checkNotNull(nameQuery, "nameQuery");
        this.limit = limit;
        this.offset = offset;
        this.orderBy = orderBy;
        this.nameQuery = nameQuery;
    }

    public ListOAuthApplicationsRequest() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<Long> limit() {
        return this.limit;
    }

    @JsonIgnore
    public Optional<Long> offset() {
        return this.offset;
    }

    @JsonIgnore
    public Optional<String> orderBy() {
        return this.orderBy;
    }

    @JsonIgnore
    public Optional<String> nameQuery() {
        return this.nameQuery;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ListOAuthApplicationsRequest withLimit(long limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.ofNullable(limit);
        return this;
    }

    public ListOAuthApplicationsRequest withLimit(Optional<Long> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public ListOAuthApplicationsRequest withOffset(long offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = Optional.ofNullable(offset);
        return this;
    }

    public ListOAuthApplicationsRequest withOffset(Optional<Long> offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = offset;
        return this;
    }

    public ListOAuthApplicationsRequest withOrderBy(String orderBy) {
        Utils.checkNotNull(orderBy, "orderBy");
        this.orderBy = Optional.ofNullable(orderBy);
        return this;
    }

    public ListOAuthApplicationsRequest withOrderBy(Optional<String> orderBy) {
        Utils.checkNotNull(orderBy, "orderBy");
        this.orderBy = orderBy;
        return this;
    }

    public ListOAuthApplicationsRequest withNameQuery(String nameQuery) {
        Utils.checkNotNull(nameQuery, "nameQuery");
        this.nameQuery = Optional.ofNullable(nameQuery);
        return this;
    }

    public ListOAuthApplicationsRequest withNameQuery(Optional<String> nameQuery) {
        Utils.checkNotNull(nameQuery, "nameQuery");
        this.nameQuery = nameQuery;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListOAuthApplicationsRequest other = (ListOAuthApplicationsRequest)o;
        return Utils.enhancedDeepEquals(this.limit, other.limit) && Utils.enhancedDeepEquals(this.offset, other.offset) && Utils.enhancedDeepEquals(this.orderBy, other.orderBy) && Utils.enhancedDeepEquals(this.nameQuery, other.nameQuery);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.limit, this.offset, this.orderBy, this.nameQuery);
    }

    public String toString() {
        return Utils.toString(ListOAuthApplicationsRequest.class, "limit", this.limit, "offset", this.offset, "orderBy", this.orderBy, "nameQuery", this.nameQuery);
    }

    public static final class Builder {
        private Optional<Long> limit;
        private Optional<Long> offset;
        private Optional<String> orderBy;
        private Optional<String> nameQuery = Optional.empty();
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Limit = new LazySingletonValue<Optional<Long>>("limit", "10", new TypeReference<Optional<Long>>(){});
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Offset = new LazySingletonValue<Optional<Long>>("offset", "0", new TypeReference<Optional<Long>>(){});
        private static final LazySingletonValue<Optional<String>> _SINGLETON_VALUE_OrderBy = new LazySingletonValue<Optional<String>>("order_by", "\"+created_at\"", new TypeReference<Optional<String>>(){});

        private Builder() {
        }

        public Builder limit(long limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public Builder limit(Optional<Long> limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = limit;
            return this;
        }

        public Builder offset(long offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public Builder offset(Optional<Long> offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = offset;
            return this;
        }

        public Builder orderBy(String orderBy) {
            Utils.checkNotNull(orderBy, "orderBy");
            this.orderBy = Optional.ofNullable(orderBy);
            return this;
        }

        public Builder orderBy(Optional<String> orderBy) {
            Utils.checkNotNull(orderBy, "orderBy");
            this.orderBy = orderBy;
            return this;
        }

        public Builder nameQuery(String nameQuery) {
            Utils.checkNotNull(nameQuery, "nameQuery");
            this.nameQuery = Optional.ofNullable(nameQuery);
            return this;
        }

        public Builder nameQuery(Optional<String> nameQuery) {
            Utils.checkNotNull(nameQuery, "nameQuery");
            this.nameQuery = nameQuery;
            return this;
        }

        public ListOAuthApplicationsRequest build() {
            if (this.limit == null) {
                this.limit = _SINGLETON_VALUE_Limit.value();
            }
            if (this.offset == null) {
                this.offset = _SINGLETON_VALUE_Offset.value();
            }
            if (this.orderBy == null) {
                this.orderBy = _SINGLETON_VALUE_OrderBy.value();
            }
            return new ListOAuthApplicationsRequest(this.limit, this.offset, this.orderBy, this.nameQuery);
        }
    }
}

