/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.ListOAuthApplicationsRequest;
import com.clerk.backend_api.models.operations.ListOAuthApplicationsResponse;
import com.clerk.backend_api.operations.ListOAuthApplications;
import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Optional;

public class ListOAuthApplicationsRequestBuilder {
    private Optional<Long> limit = Utils.readDefaultOrConstValue("limit", "10", new TypeReference<Optional<Long>>(){});
    private Optional<Long> offset = Utils.readDefaultOrConstValue("offset", "0", new TypeReference<Optional<Long>>(){});
    private Optional<String> orderBy = Utils.readDefaultOrConstValue("orderBy", "\"+created_at\"", new TypeReference<Optional<String>>(){});
    private Optional<String> nameQuery = Optional.empty();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Limit = new LazySingletonValue<Optional<Long>>("limit", "10", new TypeReference<Optional<Long>>(){});
    private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Offset = new LazySingletonValue<Optional<Long>>("offset", "0", new TypeReference<Optional<Long>>(){});
    private static final LazySingletonValue<Optional<String>> _SINGLETON_VALUE_OrderBy = new LazySingletonValue<Optional<String>>("orderBy", "\"+created_at\"", new TypeReference<Optional<String>>(){});

    public ListOAuthApplicationsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public ListOAuthApplicationsRequestBuilder limit(long limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.of(limit);
        return this;
    }

    public ListOAuthApplicationsRequestBuilder limit(Optional<Long> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public ListOAuthApplicationsRequestBuilder offset(long offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = Optional.of(offset);
        return this;
    }

    public ListOAuthApplicationsRequestBuilder offset(Optional<Long> offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = offset;
        return this;
    }

    public ListOAuthApplicationsRequestBuilder orderBy(String orderBy) {
        Utils.checkNotNull(orderBy, "orderBy");
        this.orderBy = Optional.of(orderBy);
        return this;
    }

    public ListOAuthApplicationsRequestBuilder orderBy(Optional<String> orderBy) {
        Utils.checkNotNull(orderBy, "orderBy");
        this.orderBy = orderBy;
        return this;
    }

    public ListOAuthApplicationsRequestBuilder nameQuery(String nameQuery) {
        Utils.checkNotNull(nameQuery, "nameQuery");
        this.nameQuery = Optional.of(nameQuery);
        return this;
    }

    public ListOAuthApplicationsRequestBuilder nameQuery(Optional<String> nameQuery) {
        Utils.checkNotNull(nameQuery, "nameQuery");
        this.nameQuery = nameQuery;
        return this;
    }

    public ListOAuthApplicationsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public ListOAuthApplicationsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private ListOAuthApplicationsRequest buildRequest() {
        if (this.limit == null) {
            this.limit = _SINGLETON_VALUE_Limit.value();
        }
        if (this.offset == null) {
            this.offset = _SINGLETON_VALUE_Offset.value();
        }
        if (this.orderBy == null) {
            this.orderBy = _SINGLETON_VALUE_OrderBy.value();
        }
        ListOAuthApplicationsRequest request = new ListOAuthApplicationsRequest(this.limit, this.offset, this.orderBy, this.nameQuery);
        return request;
    }

    public ListOAuthApplicationsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        ListOAuthApplications.Sync operation = new ListOAuthApplications.Sync(this.sdkConfiguration, options);
        ListOAuthApplicationsRequest request = this.buildRequest();
        return (ListOAuthApplicationsResponse)operation.handleResponse(operation.doRequest(request));
    }
}

