/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.OAuthApplications;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class ListOAuthApplicationsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends OAuthApplications> oAuthApplications;

    @JsonCreator
    public ListOAuthApplicationsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends OAuthApplications> oAuthApplications) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(oAuthApplications, "oAuthApplications");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.oAuthApplications = oAuthApplications;
    }

    public ListOAuthApplicationsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<OAuthApplications> oAuthApplications() {
        return this.oAuthApplications;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ListOAuthApplicationsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public ListOAuthApplicationsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public ListOAuthApplicationsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public ListOAuthApplicationsResponse withOAuthApplications(OAuthApplications oAuthApplications) {
        Utils.checkNotNull(oAuthApplications, "oAuthApplications");
        this.oAuthApplications = Optional.ofNullable(oAuthApplications);
        return this;
    }

    public ListOAuthApplicationsResponse withOAuthApplications(Optional<? extends OAuthApplications> oAuthApplications) {
        Utils.checkNotNull(oAuthApplications, "oAuthApplications");
        this.oAuthApplications = oAuthApplications;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListOAuthApplicationsResponse other = (ListOAuthApplicationsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.oAuthApplications, other.oAuthApplications);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.oAuthApplications);
    }

    public String toString() {
        return Utils.toString(ListOAuthApplicationsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "oAuthApplications", this.oAuthApplications);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends OAuthApplications> oAuthApplications = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder oAuthApplications(OAuthApplications oAuthApplications) {
            Utils.checkNotNull(oAuthApplications, "oAuthApplications");
            this.oAuthApplications = Optional.ofNullable(oAuthApplications);
            return this;
        }

        public Builder oAuthApplications(Optional<? extends OAuthApplications> oAuthApplications) {
            Utils.checkNotNull(oAuthApplications, "oAuthApplications");
            this.oAuthApplications = oAuthApplications;
            return this;
        }

        public ListOAuthApplicationsResponse build() {
            return new ListOAuthApplicationsResponse(this.contentType, this.statusCode, this.rawResponse, this.oAuthApplications);
        }
    }
}

