/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Optional;

public class ListOrganizationDomainsRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=organization_id")
    private String organizationId;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=verified")
    private Optional<String> verified;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=enrollment_mode")
    private Optional<String> enrollmentMode;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=limit")
    private Optional<Long> limit;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=offset")
    private Optional<Long> offset;

    @JsonCreator
    public ListOrganizationDomainsRequest(String organizationId, Optional<String> verified, Optional<String> enrollmentMode, Optional<Long> limit, Optional<Long> offset) {
        Utils.checkNotNull(organizationId, "organizationId");
        Utils.checkNotNull(verified, "verified");
        Utils.checkNotNull(enrollmentMode, "enrollmentMode");
        Utils.checkNotNull(limit, "limit");
        Utils.checkNotNull(offset, "offset");
        this.organizationId = organizationId;
        this.verified = verified;
        this.enrollmentMode = enrollmentMode;
        this.limit = limit;
        this.offset = offset;
    }

    public ListOrganizationDomainsRequest(String organizationId) {
        this(organizationId, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public String organizationId() {
        return this.organizationId;
    }

    @JsonIgnore
    public Optional<String> verified() {
        return this.verified;
    }

    @JsonIgnore
    public Optional<String> enrollmentMode() {
        return this.enrollmentMode;
    }

    @JsonIgnore
    public Optional<Long> limit() {
        return this.limit;
    }

    @JsonIgnore
    public Optional<Long> offset() {
        return this.offset;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ListOrganizationDomainsRequest withOrganizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public ListOrganizationDomainsRequest withVerified(String verified) {
        Utils.checkNotNull(verified, "verified");
        this.verified = Optional.ofNullable(verified);
        return this;
    }

    public ListOrganizationDomainsRequest withVerified(Optional<String> verified) {
        Utils.checkNotNull(verified, "verified");
        this.verified = verified;
        return this;
    }

    public ListOrganizationDomainsRequest withEnrollmentMode(String enrollmentMode) {
        Utils.checkNotNull(enrollmentMode, "enrollmentMode");
        this.enrollmentMode = Optional.ofNullable(enrollmentMode);
        return this;
    }

    public ListOrganizationDomainsRequest withEnrollmentMode(Optional<String> enrollmentMode) {
        Utils.checkNotNull(enrollmentMode, "enrollmentMode");
        this.enrollmentMode = enrollmentMode;
        return this;
    }

    public ListOrganizationDomainsRequest withLimit(long limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.ofNullable(limit);
        return this;
    }

    public ListOrganizationDomainsRequest withLimit(Optional<Long> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public ListOrganizationDomainsRequest withOffset(long offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = Optional.ofNullable(offset);
        return this;
    }

    public ListOrganizationDomainsRequest withOffset(Optional<Long> offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = offset;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListOrganizationDomainsRequest other = (ListOrganizationDomainsRequest)o;
        return Utils.enhancedDeepEquals(this.organizationId, other.organizationId) && Utils.enhancedDeepEquals(this.verified, other.verified) && Utils.enhancedDeepEquals(this.enrollmentMode, other.enrollmentMode) && Utils.enhancedDeepEquals(this.limit, other.limit) && Utils.enhancedDeepEquals(this.offset, other.offset);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.organizationId, this.verified, this.enrollmentMode, this.limit, this.offset);
    }

    public String toString() {
        return Utils.toString(ListOrganizationDomainsRequest.class, "organizationId", this.organizationId, "verified", this.verified, "enrollmentMode", this.enrollmentMode, "limit", this.limit, "offset", this.offset);
    }

    public static final class Builder {
        private String organizationId;
        private Optional<String> verified = Optional.empty();
        private Optional<String> enrollmentMode = Optional.empty();
        private Optional<Long> limit;
        private Optional<Long> offset;
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Limit = new LazySingletonValue<Optional<Long>>("limit", "10", new TypeReference<Optional<Long>>(){});
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Offset = new LazySingletonValue<Optional<Long>>("offset", "0", new TypeReference<Optional<Long>>(){});

        private Builder() {
        }

        public Builder organizationId(String organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = organizationId;
            return this;
        }

        public Builder verified(String verified) {
            Utils.checkNotNull(verified, "verified");
            this.verified = Optional.ofNullable(verified);
            return this;
        }

        public Builder verified(Optional<String> verified) {
            Utils.checkNotNull(verified, "verified");
            this.verified = verified;
            return this;
        }

        public Builder enrollmentMode(String enrollmentMode) {
            Utils.checkNotNull(enrollmentMode, "enrollmentMode");
            this.enrollmentMode = Optional.ofNullable(enrollmentMode);
            return this;
        }

        public Builder enrollmentMode(Optional<String> enrollmentMode) {
            Utils.checkNotNull(enrollmentMode, "enrollmentMode");
            this.enrollmentMode = enrollmentMode;
            return this;
        }

        public Builder limit(long limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public Builder limit(Optional<Long> limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = limit;
            return this;
        }

        public Builder offset(long offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public Builder offset(Optional<Long> offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = offset;
            return this;
        }

        public ListOrganizationDomainsRequest build() {
            if (this.limit == null) {
                this.limit = _SINGLETON_VALUE_Limit.value();
            }
            if (this.offset == null) {
                this.offset = _SINGLETON_VALUE_Offset.value();
            }
            return new ListOrganizationDomainsRequest(this.organizationId, this.verified, this.enrollmentMode, this.limit, this.offset);
        }
    }
}

