/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Optional;

public class ListOrganizationsRequest {
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=include_members_count")
    private Optional<Boolean> includeMembersCount;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=include_missing_member_with_elevated_permissions")
    private Optional<Boolean> includeMissingMemberWithElevatedPermissions;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=query")
    private Optional<String> query;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=user_id")
    private Optional<? extends List<String>> userId;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=organization_id")
    private Optional<? extends List<String>> organizationId;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=order_by")
    private Optional<String> orderBy;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=limit")
    private Optional<Long> limit;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=offset")
    private Optional<Long> offset;

    @JsonCreator
    public ListOrganizationsRequest(Optional<Boolean> includeMembersCount, Optional<Boolean> includeMissingMemberWithElevatedPermissions, Optional<String> query, Optional<? extends List<String>> userId, Optional<? extends List<String>> organizationId, Optional<String> orderBy, Optional<Long> limit, Optional<Long> offset) {
        Utils.checkNotNull(includeMembersCount, "includeMembersCount");
        Utils.checkNotNull(includeMissingMemberWithElevatedPermissions, "includeMissingMemberWithElevatedPermissions");
        Utils.checkNotNull(query, "query");
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(organizationId, "organizationId");
        Utils.checkNotNull(orderBy, "orderBy");
        Utils.checkNotNull(limit, "limit");
        Utils.checkNotNull(offset, "offset");
        this.includeMembersCount = includeMembersCount;
        this.includeMissingMemberWithElevatedPermissions = includeMissingMemberWithElevatedPermissions;
        this.query = query;
        this.userId = userId;
        this.organizationId = organizationId;
        this.orderBy = orderBy;
        this.limit = limit;
        this.offset = offset;
    }

    public ListOrganizationsRequest() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<Boolean> includeMembersCount() {
        return this.includeMembersCount;
    }

    @JsonIgnore
    public Optional<Boolean> includeMissingMemberWithElevatedPermissions() {
        return this.includeMissingMemberWithElevatedPermissions;
    }

    @JsonIgnore
    public Optional<String> query() {
        return this.query;
    }

    @JsonIgnore
    public Optional<List<String>> userId() {
        return this.userId;
    }

    @JsonIgnore
    public Optional<List<String>> organizationId() {
        return this.organizationId;
    }

    @JsonIgnore
    public Optional<String> orderBy() {
        return this.orderBy;
    }

    @JsonIgnore
    public Optional<Long> limit() {
        return this.limit;
    }

    @JsonIgnore
    public Optional<Long> offset() {
        return this.offset;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ListOrganizationsRequest withIncludeMembersCount(boolean includeMembersCount) {
        Utils.checkNotNull(includeMembersCount, "includeMembersCount");
        this.includeMembersCount = Optional.ofNullable(includeMembersCount);
        return this;
    }

    public ListOrganizationsRequest withIncludeMembersCount(Optional<Boolean> includeMembersCount) {
        Utils.checkNotNull(includeMembersCount, "includeMembersCount");
        this.includeMembersCount = includeMembersCount;
        return this;
    }

    public ListOrganizationsRequest withIncludeMissingMemberWithElevatedPermissions(boolean includeMissingMemberWithElevatedPermissions) {
        Utils.checkNotNull(includeMissingMemberWithElevatedPermissions, "includeMissingMemberWithElevatedPermissions");
        this.includeMissingMemberWithElevatedPermissions = Optional.ofNullable(includeMissingMemberWithElevatedPermissions);
        return this;
    }

    public ListOrganizationsRequest withIncludeMissingMemberWithElevatedPermissions(Optional<Boolean> includeMissingMemberWithElevatedPermissions) {
        Utils.checkNotNull(includeMissingMemberWithElevatedPermissions, "includeMissingMemberWithElevatedPermissions");
        this.includeMissingMemberWithElevatedPermissions = includeMissingMemberWithElevatedPermissions;
        return this;
    }

    public ListOrganizationsRequest withQuery(String query) {
        Utils.checkNotNull(query, "query");
        this.query = Optional.ofNullable(query);
        return this;
    }

    public ListOrganizationsRequest withQuery(Optional<String> query) {
        Utils.checkNotNull(query, "query");
        this.query = query;
        return this;
    }

    public ListOrganizationsRequest withUserId(List<String> userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = Optional.ofNullable(userId);
        return this;
    }

    public ListOrganizationsRequest withUserId(Optional<? extends List<String>> userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public ListOrganizationsRequest withOrganizationId(List<String> organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = Optional.ofNullable(organizationId);
        return this;
    }

    public ListOrganizationsRequest withOrganizationId(Optional<? extends List<String>> organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public ListOrganizationsRequest withOrderBy(String orderBy) {
        Utils.checkNotNull(orderBy, "orderBy");
        this.orderBy = Optional.ofNullable(orderBy);
        return this;
    }

    public ListOrganizationsRequest withOrderBy(Optional<String> orderBy) {
        Utils.checkNotNull(orderBy, "orderBy");
        this.orderBy = orderBy;
        return this;
    }

    public ListOrganizationsRequest withLimit(long limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.ofNullable(limit);
        return this;
    }

    public ListOrganizationsRequest withLimit(Optional<Long> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public ListOrganizationsRequest withOffset(long offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = Optional.ofNullable(offset);
        return this;
    }

    public ListOrganizationsRequest withOffset(Optional<Long> offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = offset;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListOrganizationsRequest other = (ListOrganizationsRequest)o;
        return Utils.enhancedDeepEquals(this.includeMembersCount, other.includeMembersCount) && Utils.enhancedDeepEquals(this.includeMissingMemberWithElevatedPermissions, other.includeMissingMemberWithElevatedPermissions) && Utils.enhancedDeepEquals(this.query, other.query) && Utils.enhancedDeepEquals(this.userId, other.userId) && Utils.enhancedDeepEquals(this.organizationId, other.organizationId) && Utils.enhancedDeepEquals(this.orderBy, other.orderBy) && Utils.enhancedDeepEquals(this.limit, other.limit) && Utils.enhancedDeepEquals(this.offset, other.offset);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.includeMembersCount, this.includeMissingMemberWithElevatedPermissions, this.query, this.userId, this.organizationId, this.orderBy, this.limit, this.offset);
    }

    public String toString() {
        return Utils.toString(ListOrganizationsRequest.class, "includeMembersCount", this.includeMembersCount, "includeMissingMemberWithElevatedPermissions", this.includeMissingMemberWithElevatedPermissions, "query", this.query, "userId", this.userId, "organizationId", this.organizationId, "orderBy", this.orderBy, "limit", this.limit, "offset", this.offset);
    }

    public static final class Builder {
        private Optional<Boolean> includeMembersCount = Optional.empty();
        private Optional<Boolean> includeMissingMemberWithElevatedPermissions = Optional.empty();
        private Optional<String> query = Optional.empty();
        private Optional<? extends List<String>> userId = Optional.empty();
        private Optional<? extends List<String>> organizationId = Optional.empty();
        private Optional<String> orderBy;
        private Optional<Long> limit;
        private Optional<Long> offset;
        private static final LazySingletonValue<Optional<String>> _SINGLETON_VALUE_OrderBy = new LazySingletonValue<Optional<String>>("order_by", "\"-created_at\"", new TypeReference<Optional<String>>(){});
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Limit = new LazySingletonValue<Optional<Long>>("limit", "10", new TypeReference<Optional<Long>>(){});
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Offset = new LazySingletonValue<Optional<Long>>("offset", "0", new TypeReference<Optional<Long>>(){});

        private Builder() {
        }

        public Builder includeMembersCount(boolean includeMembersCount) {
            Utils.checkNotNull(includeMembersCount, "includeMembersCount");
            this.includeMembersCount = Optional.ofNullable(includeMembersCount);
            return this;
        }

        public Builder includeMembersCount(Optional<Boolean> includeMembersCount) {
            Utils.checkNotNull(includeMembersCount, "includeMembersCount");
            this.includeMembersCount = includeMembersCount;
            return this;
        }

        public Builder includeMissingMemberWithElevatedPermissions(boolean includeMissingMemberWithElevatedPermissions) {
            Utils.checkNotNull(includeMissingMemberWithElevatedPermissions, "includeMissingMemberWithElevatedPermissions");
            this.includeMissingMemberWithElevatedPermissions = Optional.ofNullable(includeMissingMemberWithElevatedPermissions);
            return this;
        }

        public Builder includeMissingMemberWithElevatedPermissions(Optional<Boolean> includeMissingMemberWithElevatedPermissions) {
            Utils.checkNotNull(includeMissingMemberWithElevatedPermissions, "includeMissingMemberWithElevatedPermissions");
            this.includeMissingMemberWithElevatedPermissions = includeMissingMemberWithElevatedPermissions;
            return this;
        }

        public Builder query(String query) {
            Utils.checkNotNull(query, "query");
            this.query = Optional.ofNullable(query);
            return this;
        }

        public Builder query(Optional<String> query) {
            Utils.checkNotNull(query, "query");
            this.query = query;
            return this;
        }

        public Builder userId(List<String> userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        public Builder userId(Optional<? extends List<String>> userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        public Builder organizationId(List<String> organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = Optional.ofNullable(organizationId);
            return this;
        }

        public Builder organizationId(Optional<? extends List<String>> organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = organizationId;
            return this;
        }

        public Builder orderBy(String orderBy) {
            Utils.checkNotNull(orderBy, "orderBy");
            this.orderBy = Optional.ofNullable(orderBy);
            return this;
        }

        public Builder orderBy(Optional<String> orderBy) {
            Utils.checkNotNull(orderBy, "orderBy");
            this.orderBy = orderBy;
            return this;
        }

        public Builder limit(long limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public Builder limit(Optional<Long> limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = limit;
            return this;
        }

        public Builder offset(long offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public Builder offset(Optional<Long> offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = offset;
            return this;
        }

        public ListOrganizationsRequest build() {
            if (this.orderBy == null) {
                this.orderBy = _SINGLETON_VALUE_OrderBy.value();
            }
            if (this.limit == null) {
                this.limit = _SINGLETON_VALUE_Limit.value();
            }
            if (this.offset == null) {
                this.offset = _SINGLETON_VALUE_Offset.value();
            }
            return new ListOrganizationsRequest(this.includeMembersCount, this.includeMissingMemberWithElevatedPermissions, this.query, this.userId, this.organizationId, this.orderBy, this.limit, this.offset);
        }
    }
}

