/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.RedirectURL;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Optional;

public class ListRedirectURLsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends List<RedirectURL>> redirectURLList;

    @JsonCreator
    public ListRedirectURLsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends List<RedirectURL>> redirectURLList) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(redirectURLList, "redirectURLList");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.redirectURLList = redirectURLList;
    }

    public ListRedirectURLsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<List<RedirectURL>> redirectURLList() {
        return this.redirectURLList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ListRedirectURLsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public ListRedirectURLsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public ListRedirectURLsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public ListRedirectURLsResponse withRedirectURLList(List<RedirectURL> redirectURLList) {
        Utils.checkNotNull(redirectURLList, "redirectURLList");
        this.redirectURLList = Optional.ofNullable(redirectURLList);
        return this;
    }

    public ListRedirectURLsResponse withRedirectURLList(Optional<? extends List<RedirectURL>> redirectURLList) {
        Utils.checkNotNull(redirectURLList, "redirectURLList");
        this.redirectURLList = redirectURLList;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListRedirectURLsResponse other = (ListRedirectURLsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.redirectURLList, other.redirectURLList);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.redirectURLList);
    }

    public String toString() {
        return Utils.toString(ListRedirectURLsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "redirectURLList", this.redirectURLList);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends List<RedirectURL>> redirectURLList = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder redirectURLList(List<RedirectURL> redirectURLList) {
            Utils.checkNotNull(redirectURLList, "redirectURLList");
            this.redirectURLList = Optional.ofNullable(redirectURLList);
            return this;
        }

        public Builder redirectURLList(Optional<? extends List<RedirectURL>> redirectURLList) {
            Utils.checkNotNull(redirectURLList, "redirectURLList");
            this.redirectURLList = redirectURLList;
            return this;
        }

        public ListRedirectURLsResponse build() {
            return new ListRedirectURLsResponse(this.contentType, this.statusCode, this.rawResponse, this.redirectURLList);
        }
    }
}

