/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.ListSAMLConnectionsRequest;
import com.clerk.backend_api.models.operations.ListSAMLConnectionsResponse;
import com.clerk.backend_api.operations.ListSAMLConnections;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class ListSAMLConnectionsRequestBuilder {
    private ListSAMLConnectionsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public ListSAMLConnectionsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public ListSAMLConnectionsRequestBuilder request(ListSAMLConnectionsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public ListSAMLConnectionsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public ListSAMLConnectionsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public ListSAMLConnectionsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        ListSAMLConnections.Sync operation = new ListSAMLConnections.Sync(this.sdkConfiguration, options);
        return (ListSAMLConnectionsResponse)operation.handleResponse(operation.doRequest(this.request));
    }
}

