/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.SAMLConnections;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class ListSAMLConnectionsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends SAMLConnections> samlConnections;

    @JsonCreator
    public ListSAMLConnectionsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends SAMLConnections> samlConnections) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(samlConnections, "samlConnections");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.samlConnections = samlConnections;
    }

    public ListSAMLConnectionsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<SAMLConnections> samlConnections() {
        return this.samlConnections;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ListSAMLConnectionsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public ListSAMLConnectionsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public ListSAMLConnectionsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public ListSAMLConnectionsResponse withSAMLConnections(SAMLConnections samlConnections) {
        Utils.checkNotNull(samlConnections, "samlConnections");
        this.samlConnections = Optional.ofNullable(samlConnections);
        return this;
    }

    public ListSAMLConnectionsResponse withSAMLConnections(Optional<? extends SAMLConnections> samlConnections) {
        Utils.checkNotNull(samlConnections, "samlConnections");
        this.samlConnections = samlConnections;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListSAMLConnectionsResponse other = (ListSAMLConnectionsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.samlConnections, other.samlConnections);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.samlConnections);
    }

    public String toString() {
        return Utils.toString(ListSAMLConnectionsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "samlConnections", this.samlConnections);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends SAMLConnections> samlConnections = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder samlConnections(SAMLConnections samlConnections) {
            Utils.checkNotNull(samlConnections, "samlConnections");
            this.samlConnections = Optional.ofNullable(samlConnections);
            return this;
        }

        public Builder samlConnections(Optional<? extends SAMLConnections> samlConnections) {
            Utils.checkNotNull(samlConnections, "samlConnections");
            this.samlConnections = samlConnections;
            return this;
        }

        public ListSAMLConnectionsResponse build() {
            return new ListSAMLConnectionsResponse(this.contentType, this.statusCode, this.rawResponse, this.samlConnections);
        }
    }
}

