/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.WaitlistEntries;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class ListWaitlistEntriesResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends WaitlistEntries> waitlistEntries;

    @JsonCreator
    public ListWaitlistEntriesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends WaitlistEntries> waitlistEntries) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(waitlistEntries, "waitlistEntries");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.waitlistEntries = waitlistEntries;
    }

    public ListWaitlistEntriesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<WaitlistEntries> waitlistEntries() {
        return this.waitlistEntries;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ListWaitlistEntriesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public ListWaitlistEntriesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public ListWaitlistEntriesResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public ListWaitlistEntriesResponse withWaitlistEntries(WaitlistEntries waitlistEntries) {
        Utils.checkNotNull(waitlistEntries, "waitlistEntries");
        this.waitlistEntries = Optional.ofNullable(waitlistEntries);
        return this;
    }

    public ListWaitlistEntriesResponse withWaitlistEntries(Optional<? extends WaitlistEntries> waitlistEntries) {
        Utils.checkNotNull(waitlistEntries, "waitlistEntries");
        this.waitlistEntries = waitlistEntries;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListWaitlistEntriesResponse other = (ListWaitlistEntriesResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.waitlistEntries, other.waitlistEntries);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.waitlistEntries);
    }

    public String toString() {
        return Utils.toString(ListWaitlistEntriesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "waitlistEntries", this.waitlistEntries);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends WaitlistEntries> waitlistEntries = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder waitlistEntries(WaitlistEntries waitlistEntries) {
            Utils.checkNotNull(waitlistEntries, "waitlistEntries");
            this.waitlistEntries = Optional.ofNullable(waitlistEntries);
            return this;
        }

        public Builder waitlistEntries(Optional<? extends WaitlistEntries> waitlistEntries) {
            Utils.checkNotNull(waitlistEntries, "waitlistEntries");
            this.waitlistEntries = waitlistEntries;
            return this;
        }

        public ListWaitlistEntriesResponse build() {
            return new ListWaitlistEntriesResponse(this.contentType, this.statusCode, this.rawResponse, this.waitlistEntries);
        }
    }
}

