/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.GetM2MTokensObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class M2mTokens {
    @JsonProperty(value="object")
    private GetM2MTokensObject object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="subject")
    private String subject;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="claims")
    private JsonNullable<? extends Object> claims;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="scopes")
    private Optional<? extends List<String>> scopes;
    @JsonProperty(value="revoked")
    private boolean revoked;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="revocation_reason")
    private Optional<String> revocationReason;
    @JsonProperty(value="expired")
    private boolean expired;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="expiration")
    private Optional<Double> expiration;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="last_used_at")
    private Optional<Double> lastUsedAt;
    @JsonProperty(value="created_at")
    private double createdAt;
    @JsonProperty(value="updated_at")
    private double updatedAt;

    @JsonCreator
    public M2mTokens(@JsonProperty(value="object") GetM2MTokensObject object, @JsonProperty(value="id") String id, @JsonProperty(value="subject") String subject, @JsonProperty(value="claims") JsonNullable<? extends Object> claims, @JsonProperty(value="scopes") Optional<? extends List<String>> scopes, @JsonProperty(value="revoked") boolean revoked, @JsonProperty(value="revocation_reason") Optional<String> revocationReason, @JsonProperty(value="expired") boolean expired, @JsonProperty(value="expiration") Optional<Double> expiration, @JsonProperty(value="last_used_at") Optional<Double> lastUsedAt, @JsonProperty(value="created_at") double createdAt, @JsonProperty(value="updated_at") double updatedAt) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(subject, "subject");
        Utils.checkNotNull(claims, "claims");
        Utils.checkNotNull(scopes, "scopes");
        Utils.checkNotNull(revoked, "revoked");
        Utils.checkNotNull(revocationReason, "revocationReason");
        Utils.checkNotNull(expired, "expired");
        Utils.checkNotNull(expiration, "expiration");
        Utils.checkNotNull(lastUsedAt, "lastUsedAt");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.object = object;
        this.id = id;
        this.subject = subject;
        this.claims = claims;
        this.scopes = scopes;
        this.revoked = revoked;
        this.revocationReason = revocationReason;
        this.expired = expired;
        this.expiration = expiration;
        this.lastUsedAt = lastUsedAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public M2mTokens(GetM2MTokensObject object, String id, String subject, boolean revoked, boolean expired, double createdAt, double updatedAt) {
        this(object, id, subject, (JsonNullable<? extends Object>)JsonNullable.undefined(), Optional.empty(), revoked, Optional.empty(), expired, Optional.empty(), Optional.empty(), createdAt, updatedAt);
    }

    @JsonIgnore
    public GetM2MTokensObject object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String subject() {
        return this.subject;
    }

    @JsonIgnore
    public JsonNullable<Object> claims() {
        return this.claims;
    }

    @JsonIgnore
    public Optional<List<String>> scopes() {
        return this.scopes;
    }

    @JsonIgnore
    public boolean revoked() {
        return this.revoked;
    }

    @JsonIgnore
    public Optional<String> revocationReason() {
        return this.revocationReason;
    }

    @JsonIgnore
    public boolean expired() {
        return this.expired;
    }

    @JsonIgnore
    public Optional<Double> expiration() {
        return this.expiration;
    }

    @JsonIgnore
    public Optional<Double> lastUsedAt() {
        return this.lastUsedAt;
    }

    @JsonIgnore
    public double createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public double updatedAt() {
        return this.updatedAt;
    }

    public static Builder builder() {
        return new Builder();
    }

    public M2mTokens withObject(GetM2MTokensObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public M2mTokens withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public M2mTokens withSubject(String subject) {
        Utils.checkNotNull(subject, "subject");
        this.subject = subject;
        return this;
    }

    public M2mTokens withClaims(Object claims) {
        Utils.checkNotNull(claims, "claims");
        this.claims = JsonNullable.of((Object)claims);
        return this;
    }

    public M2mTokens withClaims(JsonNullable<? extends Object> claims) {
        Utils.checkNotNull(claims, "claims");
        this.claims = claims;
        return this;
    }

    public M2mTokens withScopes(List<String> scopes) {
        Utils.checkNotNull(scopes, "scopes");
        this.scopes = Optional.ofNullable(scopes);
        return this;
    }

    public M2mTokens withScopes(Optional<? extends List<String>> scopes) {
        Utils.checkNotNull(scopes, "scopes");
        this.scopes = scopes;
        return this;
    }

    public M2mTokens withRevoked(boolean revoked) {
        Utils.checkNotNull(revoked, "revoked");
        this.revoked = revoked;
        return this;
    }

    public M2mTokens withRevocationReason(String revocationReason) {
        Utils.checkNotNull(revocationReason, "revocationReason");
        this.revocationReason = Optional.ofNullable(revocationReason);
        return this;
    }

    public M2mTokens withRevocationReason(Optional<String> revocationReason) {
        Utils.checkNotNull(revocationReason, "revocationReason");
        this.revocationReason = revocationReason;
        return this;
    }

    public M2mTokens withExpired(boolean expired) {
        Utils.checkNotNull(expired, "expired");
        this.expired = expired;
        return this;
    }

    public M2mTokens withExpiration(double expiration) {
        Utils.checkNotNull(expiration, "expiration");
        this.expiration = Optional.ofNullable(expiration);
        return this;
    }

    public M2mTokens withExpiration(Optional<Double> expiration) {
        Utils.checkNotNull(expiration, "expiration");
        this.expiration = expiration;
        return this;
    }

    public M2mTokens withLastUsedAt(double lastUsedAt) {
        Utils.checkNotNull(lastUsedAt, "lastUsedAt");
        this.lastUsedAt = Optional.ofNullable(lastUsedAt);
        return this;
    }

    public M2mTokens withLastUsedAt(Optional<Double> lastUsedAt) {
        Utils.checkNotNull(lastUsedAt, "lastUsedAt");
        this.lastUsedAt = lastUsedAt;
        return this;
    }

    public M2mTokens withCreatedAt(double createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public M2mTokens withUpdatedAt(double updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        M2mTokens other = (M2mTokens)o;
        return Utils.enhancedDeepEquals((Object)this.object, (Object)other.object) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.subject, other.subject) && Utils.enhancedDeepEquals(this.claims, other.claims) && Utils.enhancedDeepEquals(this.scopes, other.scopes) && Utils.enhancedDeepEquals(this.revoked, other.revoked) && Utils.enhancedDeepEquals(this.revocationReason, other.revocationReason) && Utils.enhancedDeepEquals(this.expired, other.expired) && Utils.enhancedDeepEquals(this.expiration, other.expiration) && Utils.enhancedDeepEquals(this.lastUsedAt, other.lastUsedAt) && Utils.enhancedDeepEquals(this.createdAt, other.createdAt) && Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.object, this.id, this.subject, this.claims, this.scopes, this.revoked, this.revocationReason, this.expired, this.expiration, this.lastUsedAt, this.createdAt, this.updatedAt});
    }

    public String toString() {
        return Utils.toString(M2mTokens.class, new Object[]{"object", this.object, "id", this.id, "subject", this.subject, "claims", this.claims, "scopes", this.scopes, "revoked", this.revoked, "revocationReason", this.revocationReason, "expired", this.expired, "expiration", this.expiration, "lastUsedAt", this.lastUsedAt, "createdAt", this.createdAt, "updatedAt", this.updatedAt});
    }

    public static final class Builder {
        private GetM2MTokensObject object;
        private String id;
        private String subject;
        private JsonNullable<? extends Object> claims = JsonNullable.undefined();
        private Optional<? extends List<String>> scopes = Optional.empty();
        private Boolean revoked;
        private Optional<String> revocationReason = Optional.empty();
        private Boolean expired;
        private Optional<Double> expiration = Optional.empty();
        private Optional<Double> lastUsedAt = Optional.empty();
        private Double createdAt;
        private Double updatedAt;

        private Builder() {
        }

        public Builder object(GetM2MTokensObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder subject(String subject) {
            Utils.checkNotNull(subject, "subject");
            this.subject = subject;
            return this;
        }

        public Builder claims(Object claims) {
            Utils.checkNotNull(claims, "claims");
            this.claims = JsonNullable.of((Object)claims);
            return this;
        }

        public Builder claims(JsonNullable<? extends Object> claims) {
            Utils.checkNotNull(claims, "claims");
            this.claims = claims;
            return this;
        }

        public Builder scopes(List<String> scopes) {
            Utils.checkNotNull(scopes, "scopes");
            this.scopes = Optional.ofNullable(scopes);
            return this;
        }

        public Builder scopes(Optional<? extends List<String>> scopes) {
            Utils.checkNotNull(scopes, "scopes");
            this.scopes = scopes;
            return this;
        }

        public Builder revoked(boolean revoked) {
            Utils.checkNotNull(revoked, "revoked");
            this.revoked = revoked;
            return this;
        }

        public Builder revocationReason(String revocationReason) {
            Utils.checkNotNull(revocationReason, "revocationReason");
            this.revocationReason = Optional.ofNullable(revocationReason);
            return this;
        }

        public Builder revocationReason(Optional<String> revocationReason) {
            Utils.checkNotNull(revocationReason, "revocationReason");
            this.revocationReason = revocationReason;
            return this;
        }

        public Builder expired(boolean expired) {
            Utils.checkNotNull(expired, "expired");
            this.expired = expired;
            return this;
        }

        public Builder expiration(double expiration) {
            Utils.checkNotNull(expiration, "expiration");
            this.expiration = Optional.ofNullable(expiration);
            return this;
        }

        public Builder expiration(Optional<Double> expiration) {
            Utils.checkNotNull(expiration, "expiration");
            this.expiration = expiration;
            return this;
        }

        public Builder lastUsedAt(double lastUsedAt) {
            Utils.checkNotNull(lastUsedAt, "lastUsedAt");
            this.lastUsedAt = Optional.ofNullable(lastUsedAt);
            return this;
        }

        public Builder lastUsedAt(Optional<Double> lastUsedAt) {
            Utils.checkNotNull(lastUsedAt, "lastUsedAt");
            this.lastUsedAt = lastUsedAt;
            return this;
        }

        public Builder createdAt(double createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(double updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public M2mTokens build() {
            return new M2mTokens(this.object, this.id, this.subject, this.claims, this.scopes, this.revoked, this.revocationReason, this.expired, this.expiration, this.lastUsedAt, this.createdAt, this.updatedAt);
        }
    }
}

