/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.MergeOrganizationMetadataRequest;
import com.clerk.backend_api.models.operations.MergeOrganizationMetadataRequestBody;
import com.clerk.backend_api.models.operations.MergeOrganizationMetadataResponse;
import com.clerk.backend_api.operations.MergeOrganizationMetadata;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class MergeOrganizationMetadataRequestBuilder {
    private String organizationId;
    private MergeOrganizationMetadataRequestBody requestBody;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public MergeOrganizationMetadataRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public MergeOrganizationMetadataRequestBuilder organizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public MergeOrganizationMetadataRequestBuilder requestBody(MergeOrganizationMetadataRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public MergeOrganizationMetadataRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public MergeOrganizationMetadataRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private MergeOrganizationMetadataRequest buildRequest() {
        MergeOrganizationMetadataRequest request = new MergeOrganizationMetadataRequest(this.organizationId, this.requestBody);
        return request;
    }

    public MergeOrganizationMetadataResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        MergeOrganizationMetadata.Sync operation = new MergeOrganizationMetadata.Sync(this.sdkConfiguration, options);
        MergeOrganizationMetadataRequest request = this.buildRequest();
        return (MergeOrganizationMetadataResponse)operation.handleResponse(operation.doRequest(request));
    }
}

