/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.PreviewTemplateRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;

public class PreviewTemplateRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=template_type")
    private String templateType;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=slug")
    private String slug;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private Optional<? extends PreviewTemplateRequestBody> requestBody;

    @JsonCreator
    public PreviewTemplateRequest(String templateType, String slug, Optional<? extends PreviewTemplateRequestBody> requestBody) {
        Utils.checkNotNull(templateType, "templateType");
        Utils.checkNotNull(slug, "slug");
        Utils.checkNotNull(requestBody, "requestBody");
        this.templateType = templateType;
        this.slug = slug;
        this.requestBody = requestBody;
    }

    public PreviewTemplateRequest(String templateType, String slug) {
        this(templateType, slug, Optional.empty());
    }

    @JsonIgnore
    public String templateType() {
        return this.templateType;
    }

    @JsonIgnore
    public String slug() {
        return this.slug;
    }

    @JsonIgnore
    public Optional<PreviewTemplateRequestBody> requestBody() {
        return this.requestBody;
    }

    public static Builder builder() {
        return new Builder();
    }

    public PreviewTemplateRequest withTemplateType(String templateType) {
        Utils.checkNotNull(templateType, "templateType");
        this.templateType = templateType;
        return this;
    }

    public PreviewTemplateRequest withSlug(String slug) {
        Utils.checkNotNull(slug, "slug");
        this.slug = slug;
        return this;
    }

    public PreviewTemplateRequest withRequestBody(PreviewTemplateRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.ofNullable(requestBody);
        return this;
    }

    public PreviewTemplateRequest withRequestBody(Optional<? extends PreviewTemplateRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreviewTemplateRequest other = (PreviewTemplateRequest)o;
        return Utils.enhancedDeepEquals(this.templateType, other.templateType) && Utils.enhancedDeepEquals(this.slug, other.slug) && Utils.enhancedDeepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.templateType, this.slug, this.requestBody);
    }

    public String toString() {
        return Utils.toString(PreviewTemplateRequest.class, "templateType", this.templateType, "slug", this.slug, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String templateType;
        private String slug;
        private Optional<? extends PreviewTemplateRequestBody> requestBody = Optional.empty();

        private Builder() {
        }

        public Builder templateType(String templateType) {
            Utils.checkNotNull(templateType, "templateType");
            this.templateType = templateType;
            return this;
        }

        public Builder slug(String slug) {
            Utils.checkNotNull(slug, "slug");
            this.slug = slug;
            return this;
        }

        public Builder requestBody(PreviewTemplateRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = Optional.ofNullable(requestBody);
            return this;
        }

        public Builder requestBody(Optional<? extends PreviewTemplateRequestBody> requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public PreviewTemplateRequest build() {
            return new PreviewTemplateRequest(this.templateType, this.slug, this.requestBody);
        }
    }
}

