/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.PreviewTemplateRequest;
import com.clerk.backend_api.models.operations.PreviewTemplateRequestBody;
import com.clerk.backend_api.models.operations.PreviewTemplateResponse;
import com.clerk.backend_api.operations.PreviewTemplate;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class PreviewTemplateRequestBuilder {
    private String templateType;
    private String slug;
    private Optional<? extends PreviewTemplateRequestBody> requestBody = Optional.empty();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public PreviewTemplateRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public PreviewTemplateRequestBuilder templateType(String templateType) {
        Utils.checkNotNull(templateType, "templateType");
        this.templateType = templateType;
        return this;
    }

    public PreviewTemplateRequestBuilder slug(String slug) {
        Utils.checkNotNull(slug, "slug");
        this.slug = slug;
        return this;
    }

    public PreviewTemplateRequestBuilder requestBody(PreviewTemplateRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.of(requestBody);
        return this;
    }

    public PreviewTemplateRequestBuilder requestBody(Optional<? extends PreviewTemplateRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public PreviewTemplateRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public PreviewTemplateRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private PreviewTemplateRequest buildRequest() {
        PreviewTemplateRequest request = new PreviewTemplateRequest(this.templateType, this.slug, this.requestBody);
        return request;
    }

    public PreviewTemplateResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        PreviewTemplate.Sync operation = new PreviewTemplate.Sync(this.sdkConfiguration, options);
        PreviewTemplateRequest request = this.buildRequest();
        return (PreviewTemplateResponse)operation.handleResponse(operation.doRequest(request));
    }
}

