/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.RefreshSessionRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;

public class RefreshSessionRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=session_id")
    private String sessionId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private Optional<? extends RefreshSessionRequestBody> requestBody;

    @JsonCreator
    public RefreshSessionRequest(String sessionId, Optional<? extends RefreshSessionRequestBody> requestBody) {
        Utils.checkNotNull(sessionId, "sessionId");
        Utils.checkNotNull(requestBody, "requestBody");
        this.sessionId = sessionId;
        this.requestBody = requestBody;
    }

    public RefreshSessionRequest(String sessionId) {
        this(sessionId, Optional.empty());
    }

    @JsonIgnore
    public String sessionId() {
        return this.sessionId;
    }

    @JsonIgnore
    public Optional<RefreshSessionRequestBody> requestBody() {
        return this.requestBody;
    }

    public static Builder builder() {
        return new Builder();
    }

    public RefreshSessionRequest withSessionId(String sessionId) {
        Utils.checkNotNull(sessionId, "sessionId");
        this.sessionId = sessionId;
        return this;
    }

    public RefreshSessionRequest withRequestBody(RefreshSessionRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.ofNullable(requestBody);
        return this;
    }

    public RefreshSessionRequest withRequestBody(Optional<? extends RefreshSessionRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RefreshSessionRequest other = (RefreshSessionRequest)o;
        return Utils.enhancedDeepEquals(this.sessionId, other.sessionId) && Utils.enhancedDeepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.sessionId, this.requestBody);
    }

    public String toString() {
        return Utils.toString(RefreshSessionRequest.class, "sessionId", this.sessionId, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String sessionId;
        private Optional<? extends RefreshSessionRequestBody> requestBody = Optional.empty();

        private Builder() {
        }

        public Builder sessionId(String sessionId) {
            Utils.checkNotNull(sessionId, "sessionId");
            this.sessionId = sessionId;
            return this;
        }

        public Builder requestBody(RefreshSessionRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = Optional.ofNullable(requestBody);
            return this;
        }

        public Builder requestBody(Optional<? extends RefreshSessionRequestBody> requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public RefreshSessionRequest build() {
            return new RefreshSessionRequest(this.sessionId, this.requestBody);
        }
    }
}

