/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.RefreshSessionRequest;
import com.clerk.backend_api.models.operations.RefreshSessionRequestBody;
import com.clerk.backend_api.models.operations.RefreshSessionResponse;
import com.clerk.backend_api.operations.RefreshSession;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class RefreshSessionRequestBuilder {
    private String sessionId;
    private Optional<? extends RefreshSessionRequestBody> requestBody = Optional.empty();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public RefreshSessionRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public RefreshSessionRequestBuilder sessionId(String sessionId) {
        Utils.checkNotNull(sessionId, "sessionId");
        this.sessionId = sessionId;
        return this;
    }

    public RefreshSessionRequestBuilder requestBody(RefreshSessionRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.of(requestBody);
        return this;
    }

    public RefreshSessionRequestBuilder requestBody(Optional<? extends RefreshSessionRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public RefreshSessionRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public RefreshSessionRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private RefreshSessionRequest buildRequest() {
        RefreshSessionRequest request = new RefreshSessionRequest(this.sessionId, this.requestBody);
        return request;
    }

    public RefreshSessionResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        RefreshSession.Sync operation = new RefreshSession.Sync(this.sdkConfiguration, options);
        RefreshSessionRequest request = this.buildRequest();
        return (RefreshSessionResponse)operation.handleResponse(operation.doRequest(request));
    }
}

